package org.qubership.atp.tdm.controllers.api.dto.testdata;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.qubership.atp.tdm.controllers.api.dto.testdata.TestDataTableColumnDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestDataTableDto
 */

@JsonTypeName("TestDataTable")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-15T13:03:04.080384963Z[Etc/UTC]")
public class TestDataTableDto {

  @JsonProperty("columns")
  @Valid
  private List<TestDataTableColumnDto> columns = null;

  @JsonProperty("data")
  @Valid
  private List<Map<String, Object>> data = null;

  @JsonProperty("name")
  private String name;

  @JsonProperty("query")
  private String query;

  @JsonProperty("records")
  private Integer records;

  @JsonProperty("title")
  private String title;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    ALL("ALL"),
    
    AVAILABLE("AVAILABLE"),
    
    OCCUPIED("OCCUPIED");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  public TestDataTableDto columns(List<TestDataTableColumnDto> columns) {
    this.columns = columns;
    return this;
  }

  public TestDataTableDto addColumnsItem(TestDataTableColumnDto columnsItem) {
    if (this.columns == null) {
      this.columns = new ArrayList<>();
    }
    this.columns.add(columnsItem);
    return this;
  }

  /**
   * Get columns
   * @return columns
  */
  @Valid 
  @Schema(name = "columns", required = false)
  public List<TestDataTableColumnDto> getColumns() {
    return columns;
  }

  public void setColumns(List<TestDataTableColumnDto> columns) {
    this.columns = columns;
  }

  public TestDataTableDto data(List<Map<String, Object>> data) {
    this.data = data;
    return this;
  }

  public TestDataTableDto addDataItem(Map<String, Object> dataItem) {
    if (this.data == null) {
      this.data = new ArrayList<>();
    }
    this.data.add(dataItem);
    return this;
  }

  /**
   * Get data
   * @return data
  */
  @Valid 
  @Schema(name = "data", required = false)
  public List<Map<String, Object>> getData() {
    return data;
  }

  public void setData(List<Map<String, Object>> data) {
    this.data = data;
  }

  public TestDataTableDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestDataTableDto query(String query) {
    this.query = query;
    return this;
  }

  /**
   * Get query
   * @return query
  */
  
  @Schema(name = "query", required = false)
  public String getQuery() {
    return query;
  }

  public void setQuery(String query) {
    this.query = query;
  }

  public TestDataTableDto records(Integer records) {
    this.records = records;
    return this;
  }

  /**
   * Get records
   * @return records
  */
  
  @Schema(name = "records", required = false)
  public Integer getRecords() {
    return records;
  }

  public void setRecords(Integer records) {
    this.records = records;
  }

  public TestDataTableDto title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Get title
   * @return title
  */
  
  @Schema(name = "title", required = false)
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public TestDataTableDto type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", required = false)
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestDataTableDto testDataTable = (TestDataTableDto) o;
    return Objects.equals(this.columns, testDataTable.columns) &&
        Objects.equals(this.data, testDataTable.data) &&
        Objects.equals(this.name, testDataTable.name) &&
        Objects.equals(this.query, testDataTable.query) &&
        Objects.equals(this.records, testDataTable.records) &&
        Objects.equals(this.title, testDataTable.title) &&
        Objects.equals(this.type, testDataTable.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(columns, data, name, query, records, title, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestDataTableDto {\n");
    sb.append("    columns: ").append(toIndentedString(columns)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    records: ").append(toIndentedString(records)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

