/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.tdm.model.scheduler;

import java.util.List;
import java.util.UUID;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.qubership.atp.tdm.model.cleanup.CleanupResults;
import org.qubership.atp.tdm.service.CleanupService;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
@DisallowConcurrentExecution
public class DataCleanupJob implements Job {

    @Autowired
    private CleanupService service;

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        MDC.clear();
        UUID id = UUID.fromString(context.getJobDetail().getKey().getName());
        try {
            log.info("Running scheduled cleanup for job with id: {}", id);
            List<CleanupResults> results = service.runCleanup(id);
            log.info("Cleanup results for job with id: {} results: {}", id, results);
        } catch (Exception e) {
            log.error("An error occurred while running scheduled cleanup with id: {}", id, e);
        }
    }
}
