/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.configuration;

import javax.annotation.Nonnull;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.service.ProjectInformationService;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.service.notification.environments.EnvironmentEventListener;
import org.qubership.atp.tdm.service.notification.environments.EnvironmentsEventKafkaListener;
import org.qubership.atp.tdm.service.notification.projects.ProjectEventKafkaListener;
import org.qubership.atp.tdm.service.notification.projects.ProjectEventListener;
import org.qubership.atp.tdm.service.notification.systems.SystemEventListener;
import org.qubership.atp.tdm.service.notification.systems.SystemsEventKafkaListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;

@EnableKafka
@Configuration
public class KafkaEventListenerConfig {
    @Value(value="${kafka.enable:false}")
    private boolean kafkaEnable;
    private final TestDataService testDataService;
    private final ProjectInformationService projectInformationService;
    private final CatalogRepository catalogRepository;
    private final TdmMdcHelper tdmMdcHelper;

    public KafkaEventListenerConfig(@Nonnull TestDataService testDataService, @Nonnull ProjectInformationService projectInformationService, @Nonnull CatalogRepository catalogRepository, TdmMdcHelper helper) {
        this.testDataService = testDataService;
        this.projectInformationService = projectInformationService;
        this.catalogRepository = catalogRepository;
        this.tdmMdcHelper = helper;
    }

    @Bean
    public ProjectEventListener projectEventNotificationService() {
        if (this.kafkaEnable) {
            return new ProjectEventKafkaListener(this.testDataService, this.projectInformationService);
        }
        return event -> {};
    }

    @Bean
    public EnvironmentEventListener environmentEventNotificationService() {
        if (this.kafkaEnable) {
            return new EnvironmentsEventKafkaListener(this.testDataService, this.catalogRepository, this.tdmMdcHelper);
        }
        return event -> {};
    }

    @Bean
    public SystemEventListener systemEventNotificationService() {
        if (this.kafkaEnable) {
            return new SystemsEventKafkaListener(this.testDataService, this.catalogRepository, this.tdmMdcHelper);
        }
        return event -> {};
    }
}

