/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.mail.bulkaction;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.model.MailRequest;
import org.qubership.atp.integration.configuration.service.MailSenderService;
import org.qubership.atp.tdm.model.bulkaction.BulkActionContext;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBulkActionMailSender {
    private static final Logger log = LoggerFactory.getLogger(AbstractBulkActionMailSender.class);
    Configuration configuration;
    MailSenderService mailSender;
    String mailSenderSubject;
    String mailSenderTemplate;
    String mailSenderPath;
    boolean mailSenderEnable;
    String mailSenderFrom;

    public void send(@Nonnull BulkActionContext bulkActionContext, UUID projectId) {
        if (this.mailSenderEnable) {
            MailRequest mailRequest = new MailRequest();
            mailRequest.setFrom(this.mailSenderFrom);
            mailRequest.setSubject(String.format(this.mailSenderSubject, bulkActionContext.getId()));
            mailRequest.setTo(bulkActionContext.getRecipients());
            mailRequest.setContent(this.buildMessageContent(this.configuration, bulkActionContext.getProjectName(), bulkActionContext.getEnvironmentName(), bulkActionContext.getSystemName(), bulkActionContext.getResults()));
            HashMap<String, UUID> metadata = new HashMap<String, UUID>();
            metadata.put("projectId", projectId);
            mailRequest.setMetadata(metadata);
            this.mailSender.send(mailRequest);
        }
    }

    private String buildMessageContent(@Nonnull Configuration freemarkerConfig, final @Nonnull String projectName, final @Nonnull String environmentName, final @Nonnull String systemName, final @Nonnull List<BulkActionResult> results) {
        try {
            freemarkerConfig.setDirectoryForTemplateLoading(new File(this.mailSenderPath));
            Template template = freemarkerConfig.getTemplate(this.mailSenderTemplate);
            StringWriter writer = new StringWriter();
            template.process((Object)new HashMap<String, Object>(){
                {
                    this.put("projectName", projectName);
                    this.put("environmentName", environmentName);
                    this.put("systemName", systemName);
                    this.put("items", results);
                }
            }, (Writer)writer);
            ((Writer)writer).flush();
            return ((Object)writer).toString();
        }
        catch (TemplateException | IOException e) {
            String errorMsg = "Error observed while building message content for bulk action statistic";
            log.error(errorMsg, e);
            return errorMsg;
        }
    }
}

