/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.tdm.exceptions.internal.TdmEvaluateQueryException;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.repo.impl.extractors.TestDataExtractorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Component;

@Component
public class QueryEvaluator {
    private static final Logger log = LoggerFactory.getLogger(QueryEvaluator.class);
    private static final Integer MAX_ITERATIONS = 5;
    private static final String OPEN_BRACKET = "${";
    private static final String CLOSE_BRACKET = "}";
    private static final String DEFAULT_COUNT_QUERY = "select 5";
    private static final String TDM_TABLE_ALIAS = "tdm_table";
    private final JdbcTemplate jdbcTemplate;
    private final TestDataExtractorProvider extractorProvider;

    public String evaluate(@Nonnull String tableName, @Nonnull String query) {
        if (query.contains(OPEN_BRACKET)) {
            return this.evaluateQuery(tableName, query);
        }
        return query;
    }

    private String evaluateQuery(@Nonnull String tableName, @Nonnull String inputQuery) {
        List<String> queries = this.extractQueries(inputQuery);
        for (String query : queries) {
            String finalQuery = query.replace(TDM_TABLE_ALIAS, tableName);
            log.debug("Execute query: {}", (Object)finalQuery);
            TestDataTable table = (TestDataTable)this.jdbcTemplate.query(finalQuery, (ResultSetExtractor)this.extractorProvider.simpleExtractor(tableName, DEFAULT_COUNT_QUERY));
            if (Objects.isNull(table)) {
                log.error(String.format("Error occurred while evaluating query:  %s", query));
                throw new TdmEvaluateQueryException(query);
            }
            String result = StringUtils.join((Collection)table.getData().stream().map(data -> data.get(table.getColumns().get(0).getIdentity().getColumnName())).collect(Collectors.toList()), (String)", ");
            log.debug("Query result: {}", (Object)result);
            inputQuery = inputQuery.replace(OPEN_BRACKET + query + CLOSE_BRACKET, result);
        }
        log.debug("Evaluated query: {}", (Object)inputQuery);
        return inputQuery;
    }

    private List<String> extractQueries(@Nonnull String inputQuery) {
        int from;
        ArrayList<String> queries = new ArrayList<String>();
        int iteration = 0;
        int to = 0;
        do {
            ++iteration;
            from = inputQuery.indexOf(OPEN_BRACKET, to);
            to = inputQuery.indexOf(CLOSE_BRACKET, from);
            if (from == -1) continue;
            String query = inputQuery.substring(from + 2, to);
            queries.add(query);
        } while (from != -1 || iteration > MAX_ITERATIONS);
        return queries;
    }

    public QueryEvaluator(JdbcTemplate jdbcTemplate, TestDataExtractorProvider extractorProvider) {
        this.jdbcTemplate = jdbcTemplate;
        this.extractorProvider = extractorProvider;
    }
}

