/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import com.healthmarketscience.sqlbuilder.CreateTableQuery;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.tdm.repo.impl.SystemColumns;

public class TestDataTableCreator {
    private static final String DEFAULT_COLUMN_TYPE = "varchar";
    private static final SimpleDateFormat DB_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
    private final DbTable dbTable;
    private Map<String, DbColumn> dbColumns = new HashMap<String, DbColumn>();

    public TestDataTableCreator(@Nonnull String tableName) {
        DbSpec spec = new DbSpec();
        DbSchema schema = spec.addDefaultSchema();
        this.dbTable = schema.addTable(tableName);
        this.dbColumns.put(SystemColumns.ROW_ID.getName(), this.dbTable.addColumn("\"" + SystemColumns.ROW_ID.getName() + "\"", "uuid", null).setDefaultValue((Object)UUID.randomUUID()));
        this.dbColumns.put(SystemColumns.SELECTED.getName(), this.dbTable.addColumn("\"" + SystemColumns.SELECTED.getName() + "\"", "BOOLEAN", null).setDefaultValue((Object)"false"));
        this.dbColumns.put(SystemColumns.OCCUPIED_DATE.getName(), this.dbTable.addColumn("\"" + SystemColumns.OCCUPIED_DATE.getName() + "\"", "TIMESTAMP", null));
        this.dbColumns.put(SystemColumns.OCCUPIED_BY.getName(), this.dbTable.addColumn("\"" + SystemColumns.OCCUPIED_BY.getName() + "\"", DEFAULT_COLUMN_TYPE, null));
        this.dbColumns.put(SystemColumns.CREATED_WHEN.getName(), this.dbTable.addColumn("\"" + SystemColumns.CREATED_WHEN.getName() + "\"", "TIMESTAMP", null));
    }

    public DbColumn buildColumn(@Nonnull String columnName) {
        return this.dbTable.addColumn("\"" + columnName + "\"", DEFAULT_COLUMN_TYPE, null);
    }

    public String createTableQuery() {
        return ((CreateTableQuery)new CreateTableQuery((Table)this.dbTable, true).validate()).toString();
    }

    public InsertRowQuery initInsertRowQuery() {
        return new InsertRowQuery();
    }

    public InsertRowQuery initInsertRowQueryForImportData() {
        return new InsertRowQuery(true);
    }

    public DbTable getDbTable() {
        return this.dbTable;
    }

    public Map<String, DbColumn> getDbColumns() {
        return this.dbColumns;
    }

    public void setDbColumns(Map<String, DbColumn> dbColumns) {
        this.dbColumns = dbColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestDataTableCreator)) {
            return false;
        }
        TestDataTableCreator other = (TestDataTableCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DbTable this$dbTable = this.getDbTable();
        DbTable other$dbTable = other.getDbTable();
        if (this$dbTable == null ? other$dbTable != null : !this$dbTable.equals(other$dbTable)) {
            return false;
        }
        Map<String, DbColumn> this$dbColumns = this.getDbColumns();
        Map<String, DbColumn> other$dbColumns = other.getDbColumns();
        return !(this$dbColumns == null ? other$dbColumns != null : !((Object)this$dbColumns).equals(other$dbColumns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestDataTableCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DbTable $dbTable = this.getDbTable();
        result = result * 59 + ($dbTable == null ? 43 : $dbTable.hashCode());
        Map<String, DbColumn> $dbColumns = this.getDbColumns();
        result = result * 59 + ($dbColumns == null ? 43 : ((Object)$dbColumns).hashCode());
        return result;
    }

    public String toString() {
        return "TestDataTableCreator(dbTable=" + this.getDbTable() + ", dbColumns=" + this.getDbColumns() + ")";
    }

    public class InsertRowQuery {
        private InsertQuery insertQuery;

        InsertRowQuery() {
            this.insertQuery = new InsertQuery((Table)TestDataTableCreator.this.dbTable);
            this.insertQuery.addColumn((Column)TestDataTableCreator.this.dbColumns.get(SystemColumns.ROW_ID.getName()), (Object)UUID.randomUUID());
            this.insertQuery.addColumn((Column)TestDataTableCreator.this.dbColumns.get(SystemColumns.CREATED_WHEN.getName()), (Object)DB_DATE_FORMATTER.format(new Timestamp(new Date().getTime())));
        }

        InsertRowQuery(boolean importData) {
            this.insertQuery = new InsertQuery((Table)TestDataTableCreator.this.dbTable);
        }

        public void addRowColumn(@Nonnull DbColumn dbColumn, @Nonnull Object value) {
            this.insertQuery.addColumn((Column)dbColumn, value);
        }

        public String createQuery() {
            return ((InsertQuery)this.insertQuery.validate()).toString();
        }
    }
}

