/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.persistence.Query;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.model.LazySystem;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.model.statistics.OccupiedDataByUsersStatistics;
import org.qubership.atp.tdm.model.statistics.UsersOccupyFields;
import org.qubership.atp.tdm.model.statistics.UsersOccupyStatisticRequest;
import org.qubership.atp.tdm.model.table.OrderType;
import org.qubership.atp.tdm.model.table.TestDataTableFilter;
import org.qubership.atp.tdm.model.table.TestDataTableOrder;
import org.qubership.atp.tdm.model.table.conditions.search.SearchConditionType;

public class UsersOccupyStatisticUtils {
    private static final String FILTER_TEMPLATE = "%s LIKE %s";
    private static final String UPPER_CASE_TEMPLATE = "UPPER(%s)";
    private static final String ORDER_BY_TEMPLATE = "ORDER BY %s %s";
    private static final String IN_LIST_FILTER_TEMPLATE = "%s IN (%s)";
    private static final String EMPTY_LIST_FILTER_TEMPLATE = "%s IN (NULL)";
    private static final String ENVIRONMENT_FIELD = "catalog.environment_id";
    private static final String SYSTEM_FIELD = "stats.system_id";
    private static final String STATS_PREFIX = "stats.";
    private static final String SUMM_TEMPLATE = " sum(case when occupied_date = '%s'  then amount else 0 end) AS \"%s\",";

    public static String generateRequest(UsersOccupyStatisticRequest request, EnvironmentsService environmentsService) {
        return String.format("SELECT sourceTable.table_title, sourceTable.table_name, sourceTable.occupied_by, %s FROM (     SELECT stats.table_title, stats.table_name,         stats.occupied_by, stats.occupied_date, count(*) as amount     FROM test_data_occupy_statistic AS stats JOIN test_data_table_catalog AS catalog on stats.table_name = catalog.table_name     WHERE stats.project_id ='%s' AND occupied_date BETWEEN '%s' AND '%s' %s     GROUP BY stats.table_title, stats.table_name, occupied_by, occupied_date  ) sourceTable GROUP BY sourceTable.table_title,sourceTable.table_name, sourceTable.occupied_by %s ", UsersOccupyStatisticUtils.generateSummFields(request.getDateFrom(), request.getDateTo()), request.getProjectId(), request.getDateFrom(), request.getDateTo(), UsersOccupyStatisticUtils.setFiltersForUsersStats(request, environmentsService), UsersOccupyStatisticUtils.setOrderForUsersStats(request.getDataTableOrder()));
    }

    public static String generateSummFields(String dateFrom, String dateTo) {
        List<String> datesBetween = UsersOccupyStatisticUtils.getDatesBetween(LocalDate.parse(dateFrom), LocalDate.parse(dateTo));
        StringBuilder stringBuilder = new StringBuilder();
        datesBetween.forEach(date -> stringBuilder.append(String.format(SUMM_TEMPLATE, LocalDate.parse(date), date)));
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static List<String> getDatesBetween(LocalDate startDate, LocalDate endDate) {
        long numOfDaysBetween = ChronoUnit.DAYS.between(startDate, endDate) + 1L;
        return IntStream.iterate(0, i -> i + 1).limit(numOfDaysBetween).mapToObj(i -> startDate.plusDays(i).format(DateTimeFormatter.ISO_LOCAL_DATE)).collect(Collectors.toList());
    }

    public static Query setPagination(Query query, UsersOccupyStatisticRequest request) {
        return query.setMaxResults(Math.toIntExact(request.getLimit())).setFirstResult(Math.toIntExact(request.getOffset()));
    }

    public static String setFiltersForUsersStats(UsersOccupyStatisticRequest request, EnvironmentsService environmentsService) {
        if (!CollectionUtils.isNotEmpty(request.getFilters())) {
            return "";
        }
        StringBuilder filters = new StringBuilder("AND ");
        request.getFilters().forEach(filter -> {
            String preparedFilter = UsersOccupyStatisticUtils.chooseFilterType(filter, request.getProjectId(), environmentsService);
            if (!StringUtils.isEmpty((CharSequence)preparedFilter)) {
                filters.append(preparedFilter).append(" AND ");
            }
        });
        return filters.substring(0, filters.length() - 4);
    }

    public static String chooseFilterType(TestDataTableFilter filter, UUID projectId, EnvironmentsService environmentsService) {
        String value = filter.getValues().get(0);
        String field = STATS_PREFIX + filter.getColumn();
        SearchConditionType conditionType = SearchConditionType.find(filter.getSearchCondition());
        switch (UsersOccupyFields.find(filter.getColumn())) {
            case SYSTEM: {
                field = SYSTEM_FIELD;
                String systemSearchValue = value;
                List lazySystemList = environmentsService.getLazySystemsByProjectIdWithConnections(projectId).stream().filter(system -> {
                    if (SearchConditionType.CONTAINS.equals((Object)conditionType)) {
                        return UsersOccupyStatisticUtils.containByCaseInStream(filter, system.getName(), systemSearchValue);
                    }
                    if (SearchConditionType.START_WITH.equals((Object)conditionType)) {
                        return UsersOccupyStatisticUtils.startWithByCaseInStream(filter, system.getName(), systemSearchValue);
                    }
                    return false;
                }).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(lazySystemList)) {
                    value = lazySystemList.stream().map(LazySystem::getId).map(UUID::toString).collect(Collectors.joining("','", "'", "'"));
                    return String.format(IN_LIST_FILTER_TEMPLATE, field, value);
                }
                return String.format(EMPTY_LIST_FILTER_TEMPLATE, field);
            }
            case ENVIRONMENT: {
                String envSearchValue = value;
                field = ENVIRONMENT_FIELD;
                List lazyEnvironments = environmentsService.getLazyEnvironmentsShort(projectId).stream().filter(environment -> {
                    if (SearchConditionType.CONTAINS.equals((Object)conditionType)) {
                        return UsersOccupyStatisticUtils.containByCaseInStream(filter, environment.getName(), envSearchValue);
                    }
                    if (SearchConditionType.START_WITH.equals((Object)conditionType)) {
                        return UsersOccupyStatisticUtils.startWithByCaseInStream(filter, environment.getName(), envSearchValue);
                    }
                    return false;
                }).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(lazyEnvironments)) {
                    value = lazyEnvironments.stream().map(LazyEnvironment::getId).map(UUID::toString).collect(Collectors.joining("','", "'", "'"));
                    return String.format(IN_LIST_FILTER_TEMPLATE, field, value);
                }
                return String.format(EMPTY_LIST_FILTER_TEMPLATE, field);
            }
        }
        return UsersOccupyStatisticUtils.databaseFiltering(filter, field, value);
    }

    public static String databaseFiltering(TestDataTableFilter filter, String field, String value) {
        switch (SearchConditionType.find(filter.getSearchCondition())) {
            case CONTAINS: {
                value = "'%" + value + "%'";
                break;
            }
            case START_WITH: {
                value = "'" + value + "%'";
                break;
            }
            default: {
                return "";
            }
        }
        if (!filter.isCaseSensitive()) {
            field = String.format(UPPER_CASE_TEMPLATE, field);
            value = String.format(UPPER_CASE_TEMPLATE, value);
        }
        return String.format(FILTER_TEMPLATE, field, value);
    }

    public static boolean startWithByCaseInStream(TestDataTableFilter filter, String envName, String searchValue) {
        if (filter.isCaseSensitive()) {
            return envName.startsWith(searchValue);
        }
        return envName.toLowerCase().startsWith(searchValue.toLowerCase());
    }

    public static boolean containByCaseInStream(TestDataTableFilter filter, String envName, String searchValue) {
        if (filter.isCaseSensitive()) {
            return envName.contains(searchValue);
        }
        return envName.toLowerCase().contains(searchValue.toLowerCase());
    }

    public static String setOrderForUsersStats(TestDataTableOrder order) {
        if (order == null) {
            order = new TestDataTableOrder("occupied_by", OrderType.ASC);
        }
        return String.format(ORDER_BY_TEMPLATE, order.getColumnName(), order.getOrderType(OrderType.ASC).toString());
    }

    public static List<OccupiedDataByUsersStatistics> mapObjectsToEntity(List<Object[]> objects, LocalDate startDate) {
        ArrayList<OccupiedDataByUsersStatistics> occupiedDataByUsersStatistics = new ArrayList<OccupiedDataByUsersStatistics>();
        for (Object[] object : objects) {
            OccupiedDataByUsersStatistics statistic = new OccupiedDataByUsersStatistics((String)object[0], (String)object[2], (String)object[1]);
            for (int j = 3; j < object.length; ++j) {
                statistic.addData(startDate.plusDays(j - 3), ((BigDecimal)object[j]).longValue());
            }
            LinkedHashMap<LocalDate, Long> sortedMap = new LinkedHashMap<LocalDate, Long>();
            statistic.getData().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> sortedMap.put((LocalDate)x.getKey(), (Long)x.getValue()));
            statistic.setData(sortedMap);
            occupiedDataByUsersStatistics.add(statistic);
        }
        return occupiedDataByUsersStatistics;
    }
}

