/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.benchmarks.facades;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.qubership.atp.tdm.benchmarks.facades.GeneralFacade;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.TestDataTableFilter;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.TestDataService;

public class GetDataFacade
extends GeneralFacade {
    private static final String TEST_DATA_TABLE_FILTER_EQUALS = "tdm_benchmark_test_data_filter_equals";
    private static final String TEST_DATA_TABLE_FILTER_CONTAINS = "tdm_benchmark_test_data_filter_contains";
    private static final String TEST_DATA_TABLE_FILTER_DATES = "tdm_benchmark_test_data_filter_dates";
    private static final String TEST_DATA_TABLE_PAGINATION = "tdm_benchmark_test_data_pagination";
    private final List<TestDataTableFilter> equalFilters = this.prepareFilterEquals();
    private final List<TestDataTableFilter> containsFilters = this.prepareFilterContains();
    private final List<TestDataTableFilter> dateFilters = this.prepareFilterDates();

    public GetDataFacade(@Nonnull TestDataService testDataService, @Nonnull TestDataTableRepository testDataTableRepository) {
        super(testDataService, testDataTableRepository);
    }

    public List<TestDataTableFilter> prepareFilterEquals() {
        return Collections.singletonList(new TestDataTableFilter("SIM", "equals", this.filterValues(), false));
    }

    public TestDataTable getTestDataFilterEquals() {
        return this.testDataService.getTestData(TEST_DATA_TABLE_FILTER_EQUALS, null, null, this.equalFilters, null, Boolean.valueOf(false));
    }

    public List<TestDataTableFilter> prepareFilterContains() {
        return Collections.singletonList(new TestDataTableFilter("SIM", "contains", this.filterValues(), false));
    }

    public TestDataTable getTestDataFilterContains() {
        return this.testDataService.getTestData(TEST_DATA_TABLE_FILTER_CONTAINS, null, null, this.containsFilters, null, Boolean.valueOf(false));
    }

    public List<TestDataTableFilter> prepareFilterDates() {
        LocalDate currentDate = LocalDate.now();
        return Arrays.asList(new TestDataTableFilter("CREATED_WHEN", "From", Collections.singletonList(currentDate.toString()), false), new TestDataTableFilter("CREATED_WHEN", "To", Collections.singletonList(currentDate.toString()), false));
    }

    public TestDataTable getTestDataFilterDates() {
        return this.testDataService.getTestData(TEST_DATA_TABLE_FILTER_DATES, null, null, this.dateFilters, null, Boolean.valueOf(false));
    }

    public TestDataTable getTestDataPagination() {
        return this.testDataService.getTestData(TEST_DATA_TABLE_PAGINATION, Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(false));
    }

    public String getTableName(String filterName) {
        switch (filterName) {
            case "FilterEquals": {
                return TEST_DATA_TABLE_FILTER_EQUALS;
            }
            case "FilterContains": {
                return TEST_DATA_TABLE_FILTER_CONTAINS;
            }
            case "FilterDates": {
                return TEST_DATA_TABLE_FILTER_DATES;
            }
            case "Pagination": {
                return TEST_DATA_TABLE_PAGINATION;
            }
        }
        return "";
    }

    private List<String> filterValues() {
        return Collections.singletonList("8901260720040140973");
    }
}

