/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.benchmarks;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.qubership.atp.tdm.benchmarks.AbstractJmhTest;
import org.qubership.atp.tdm.benchmarks.facades.AtpActionsFacade;
import org.qubership.atp.tdm.benchmarks.utils.Helper;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.model.LazyProject;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.model.rest.ApiDataFilter;
import org.qubership.atp.tdm.model.rest.ResponseMessage;
import org.qubership.atp.tdm.model.rest.requests.AddInfoToRowRequest;
import org.qubership.atp.tdm.model.rest.requests.GetRowRequest;
import org.qubership.atp.tdm.model.rest.requests.OccupyRowRequest;
import org.qubership.atp.tdm.model.rest.requests.UpdateRowRequest;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.AtpActionService;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.service.impl.AtpActionServiceTest;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest
@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class AtpActions
extends AtpActionServiceTest
implements AbstractJmhTest {
    private static final String ATP_ACTIONS_OCCUPY = "tdm_benchmark_atp_actions_occupy";
    private static final String ATP_ACTIONS_UPDATE = "tdm_benchmark_atp_actions_update";
    private static final String ATP_ACTIONS_GET = "tdm_benchmark_atp_actions_get";
    private static final String ATP_ACTIONS_ADD_INFO = "tdm_benchmark_atp_actions_add_info";
    private static final UUID projectId = UUID.randomUUID();
    private static final LazyEnvironment lazyEnvironment = new LazyEnvironment(){
        {
            this.setName("Lazy Environment");
            this.setId(projectId);
        }
    };
    private static final LazyProject lazyProject = new LazyProject(){
        {
            this.setName("Lazy Project");
            this.setId(projectId);
        }
    };
    private static TestDataService benchmarkTestDataService;
    private static AtpActionService benchmarkAtpActionService;
    private static EnvironmentsService benchmarkEnvironmentsService;
    private static TestDataTableRepository benchmarkTestDataTableRepository;
    private static CatalogRepository benchmarkCatalogRepository;

    @Test
    public void runBenchmarksToReleaseData() throws Exception {
        this.setFields();
        Options opts = this.prepareOptionBuilder("jmh-atp-actions-report.json");
        new Runner(opts).run();
    }

    private void setFields() {
        benchmarkTestDataService = this.testDataService;
        benchmarkAtpActionService = this.atpActionService;
        benchmarkEnvironmentsService = this.environmentsService;
        benchmarkCatalogRepository = this.catalogRepository;
        benchmarkTestDataTableRepository = this.testDataTableRepository;
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public ResponseMessage insertTestData(InsertData data) {
        List records = this.buildTestDataTable().getData();
        return data.testingTarget.insertTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), "ATP_ACTIONS_INSERT", records);
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public List<ResponseMessage> occupyTestData(OccupyData data) {
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Assignment", "SIM", "Equals", "8901260720040140973");
        return data.testingTarget.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), "ATP_ACTIONS_OCCUPY", Collections.singletonList(occupyRowRequest));
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public List<ResponseMessage> updateTestData(UpdateData data) {
        UpdateRowRequest updateRowRequest = new UpdateRowRequest();
        List<ApiDataFilter> filters = Collections.singletonList(new ApiDataFilter("SIM", "Equals", "8901260720040140973", false));
        updateRowRequest.setFilters(filters);
        HashMap<String, String> recordWithDataForUpdate = new HashMap<String, String>();
        recordWithDataForUpdate.put("Environment", "ZLAB001");
        updateRowRequest.setRecordWithDataForUpdate(recordWithDataForUpdate);
        return data.testingTarget.updateTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), "ATP_ACTIONS_UPDATE", Collections.singletonList(updateRowRequest));
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public List<ResponseMessage> getTestData(GetData data) {
        GetRowRequest getRowRequest = this.buildGetRowRequest("Assignment", "SIM", "Equals", "8901260720040140973");
        return data.testingTarget.getTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), "ATP_ACTIONS_GET", Collections.singletonList(getRowRequest));
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public List<ResponseMessage> addInfoToRow(AddInfoData data) {
        AddInfoToRowRequest addInfoToRowRequest = new AddInfoToRowRequest();
        List<ApiDataFilter> filters = Collections.singletonList(new ApiDataFilter("SIM", "Equals", "8901260720040140973", false));
        addInfoToRowRequest.setFilters(filters);
        HashMap<String, String> recordWithDataForUpdate = new HashMap<String, String>();
        recordWithDataForUpdate.put("Environment", "ZLAB001");
        addInfoToRowRequest.setRecordWithDataForUpdate(recordWithDataForUpdate);
        return data.testingTarget.addInfoToRow(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), "ATP_ACTIONS_ADD_INFO", Collections.singletonList(addInfoToRowRequest));
    }

    @State(value=Scope.Benchmark)
    public static class InsertData {
        private AtpActionsFacade testingTarget;

        @Setup
        public void setUp() {
            Mockito.when((Object)benchmarkEnvironmentsService.getLazyProjectByName((String)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
            Mockito.when((Object)benchmarkEnvironmentsService.getLazyEnvironmentByName((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)lazyEnvironment);
            Mockito.when((Object)benchmarkEnvironmentsService.getFullSystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)system);
            this.testingTarget = new AtpActionsFacade(benchmarkTestDataService, benchmarkTestDataTableRepository, benchmarkAtpActionService);
        }
    }

    @State(value=Scope.Benchmark)
    public static class OccupyData {
        private AtpActionsFacade testingTarget;

        @Setup
        public void setUp() {
            Mockito.when((Object)benchmarkEnvironmentsService.getLazyProjectByName((String)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
            Mockito.when((Object)benchmarkEnvironmentsService.getLazyEnvironmentByName((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)lazyEnvironment);
            Mockito.when((Object)benchmarkEnvironmentsService.getFullSystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)system);
            Helper.createTestDataTableCatalog(environmentId, projectId, systemId, "ATP_ACTIONS_OCCUPY", AtpActions.ATP_ACTIONS_OCCUPY, benchmarkCatalogRepository);
            this.testingTarget = new AtpActionsFacade(benchmarkTestDataService, benchmarkTestDataTableRepository, benchmarkAtpActionService);
            this.testingTarget.createTestDataTable(AtpActions.ATP_ACTIONS_OCCUPY);
        }
    }

    @State(value=Scope.Benchmark)
    public static class UpdateData {
        private AtpActionsFacade testingTarget;

        @Setup
        public void setUp() {
            Mockito.when((Object)benchmarkEnvironmentsService.getLazyProjectByName((String)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
            Mockito.when((Object)benchmarkEnvironmentsService.getLazyEnvironmentByName((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)lazyEnvironment);
            Mockito.when((Object)benchmarkEnvironmentsService.getFullSystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)system);
            Helper.createTestDataTableCatalog(environmentId, projectId, systemId, "ATP_ACTIONS_UPDATE", AtpActions.ATP_ACTIONS_UPDATE, benchmarkCatalogRepository);
            this.testingTarget = new AtpActionsFacade(benchmarkTestDataService, benchmarkTestDataTableRepository, benchmarkAtpActionService);
            this.testingTarget.createTestDataTable(AtpActions.ATP_ACTIONS_UPDATE);
        }
    }

    @State(value=Scope.Benchmark)
    public static class GetData {
        private AtpActionsFacade testingTarget;

        @Setup
        public void setUp() {
            Mockito.when((Object)benchmarkEnvironmentsService.getLazyProjectByName((String)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
            Mockito.when((Object)benchmarkEnvironmentsService.getLazyEnvironmentByName((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)lazyEnvironment);
            Mockito.when((Object)benchmarkEnvironmentsService.getFullSystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)system);
            Helper.createTestDataTableCatalog(environmentId, projectId, systemId, "ATP_ACTIONS_GET", AtpActions.ATP_ACTIONS_GET, benchmarkCatalogRepository);
            this.testingTarget = new AtpActionsFacade(benchmarkTestDataService, benchmarkTestDataTableRepository, benchmarkAtpActionService);
            this.testingTarget.createTestDataTable(AtpActions.ATP_ACTIONS_GET);
        }
    }

    @State(value=Scope.Benchmark)
    public static class AddInfoData {
        private AtpActionsFacade testingTarget;

        @Setup
        public void setUp() {
            Mockito.when((Object)benchmarkEnvironmentsService.getLazyProjectByName((String)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
            Mockito.when((Object)benchmarkEnvironmentsService.getLazyEnvironmentByName((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)lazyEnvironment);
            Mockito.when((Object)benchmarkEnvironmentsService.getFullSystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)system);
            Helper.createTestDataTableCatalog(environmentId, projectId, systemId, "ATP_ACTIONS_ADD_INFO", AtpActions.ATP_ACTIONS_ADD_INFO, benchmarkCatalogRepository);
            this.testingTarget = new AtpActionsFacade(benchmarkTestDataService, benchmarkTestDataTableRepository, benchmarkAtpActionService);
            this.testingTarget.createTestDataTable(AtpActions.ATP_ACTIONS_ADD_INFO);
        }
    }
}

