/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.benchmarks;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.benchmarks.AbstractJmhTest;
import org.qubership.atp.tdm.benchmarks.facades.GetDataFacade;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.TestDataService;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest
@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class GetData
extends AbstractTestDataTest
implements AbstractJmhTest {
    private static TestDataService benchmarkTestDataService;
    private static TestDataTableRepository benchmarkTestDataTableRepository;

    @Test
    public void runBenchmarksToGetData() throws Exception {
        this.setFields();
        Options opts = this.prepareOptionBuilder("jmh-get-data-report.json");
        new Runner(opts).run();
    }

    private void setFields() {
        benchmarkTestDataService = this.testDataService;
        benchmarkTestDataTableRepository = this.testDataTableRepository;
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public TestDataTable getTestDataFilterEquals(GetDataFilterEquals data) {
        return data.testingTarget.getTestDataFilterEquals();
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public TestDataTable getTestDataFilterContains(GetDataFilterContains data) {
        return data.testingTarget.getTestDataFilterContains();
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public TestDataTable getTestDataDateFilter(GetDataFilterDates data) {
        return data.testingTarget.getTestDataFilterDates();
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public TestDataTable getTestDataPagination(GetDataPagination data) {
        return data.testingTarget.getTestDataPagination();
    }

    @State(value=Scope.Benchmark)
    public static class GetDataFilterEquals {
        private GetDataFacade testingTarget;

        @Setup
        public void setUp() {
            this.testingTarget = new GetDataFacade(benchmarkTestDataService, benchmarkTestDataTableRepository);
            this.testingTarget.createTestDataTable(this.testingTarget.getTableName("FilterEquals"));
        }
    }

    @State(value=Scope.Benchmark)
    public static class GetDataFilterContains {
        private GetDataFacade testingTarget;

        @Setup
        public void setUp() {
            this.testingTarget = new GetDataFacade(benchmarkTestDataService, benchmarkTestDataTableRepository);
            this.testingTarget.createTestDataTable(this.testingTarget.getTableName("FilterContains"));
        }
    }

    @State(value=Scope.Benchmark)
    public static class GetDataFilterDates {
        private GetDataFacade testingTarget;

        @Setup
        public void setUp() {
            this.testingTarget = new GetDataFacade(benchmarkTestDataService, benchmarkTestDataTableRepository);
            this.testingTarget.createTestDataTable(this.testingTarget.getTableName("FilterDates"));
        }
    }

    @State(value=Scope.Benchmark)
    public static class GetDataPagination {
        private GetDataFacade testingTarget;

        @Setup
        public void setUp() {
            this.testingTarget = new GetDataFacade(benchmarkTestDataService, benchmarkTestDataTableRepository);
            this.testingTarget.createTestDataTable(this.testingTarget.getTableName("Pagination"));
        }
    }
}

