/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.benchmarks;

import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.qubership.atp.tdm.benchmarks.AbstractJmhTest;
import org.qubership.atp.tdm.benchmarks.facades.SetupLinksFacade;
import org.qubership.atp.tdm.benchmarks.utils.Helper;
import org.qubership.atp.tdm.env.configurator.model.Project;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.ColumnService;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.service.impl.ColumnServiceTest;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest
@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class SetupLinks
extends ColumnServiceTest
implements AbstractJmhTest {
    private static final String SETUP_COLUMN_LINKS = "tdm_benchmark_setup_column_links";
    private static final UUID projectId = UUID.randomUUID();
    private static final Project project = new Project(){
        {
            this.setName("Setup Column Links Project");
            this.setId(projectId);
            this.setEnvironments(Collections.singletonList(environment));
        }
    };
    private static TestDataService benchmarkTestDataService;
    private static ColumnService benchmarkColumnService;
    private static EnvironmentsService benchmarkEnvironmentsService;
    private static TestDataTableRepository benchmarkTestDataTableRepository;
    private static CatalogRepository benchmarkCatalogRepository;

    @Test
    public void runBenchmarksToSetupColumnLinks() throws Exception {
        this.setFields();
        Options opts = this.prepareOptionBuilder("jmh-setup-links-report.json");
        new Runner(opts).run();
    }

    private void setFields() {
        benchmarkTestDataService = this.testDataService;
        benchmarkColumnService = this.columnService;
        benchmarkEnvironmentsService = this.environmentsService;
        benchmarkCatalogRepository = this.catalogRepository;
        benchmarkTestDataTableRepository = this.testDataTableRepository;
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public String setupColumnLinks(Data data) {
        return data.testingTarget.setupColumnLinks(projectId, systemId, SETUP_COLUMN_LINKS);
    }

    @State(value=Scope.Benchmark)
    public static class Data {
        private SetupLinksFacade testingTarget;

        @Setup
        public void setUp() {
            Mockito.when((Object)benchmarkEnvironmentsService.getFullProject((UUID)ArgumentMatchers.any())).thenReturn((Object)project);
            Helper.createTestDataTableCatalog(environmentId, projectId, systemId, "SETUP_COLUMN_LINKS", SetupLinks.SETUP_COLUMN_LINKS, benchmarkCatalogRepository);
            this.testingTarget = new SetupLinksFacade(benchmarkTestDataService, benchmarkTestDataTableRepository, benchmarkColumnService);
            this.testingTarget.createTestDataTable(SetupLinks.SETUP_COLUMN_LINKS);
        }
    }
}

