/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.benchmarks;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.qubership.atp.tdm.benchmarks.AbstractJmhTest;
import org.qubership.atp.tdm.benchmarks.facades.StatisticsFacade;
import org.qubership.atp.tdm.benchmarks.utils.Helper;
import org.qubership.atp.tdm.env.configurator.model.Project;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.model.statistics.ConsumedStatistics;
import org.qubership.atp.tdm.model.statistics.GeneralStatisticsItem;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.StatisticsService;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.service.impl.StatisticsServiceTest;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.jdbc.Sql;

@Sql(value={"/scripts.sql"})
@SpringBootTest
@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class Statistics
extends StatisticsServiceTest
implements AbstractJmhTest {
    private static final String TEST_DATA_TABLE_STATISTICS_AVAILABILITY = "tdm_benchmark_statistics_availability";
    private static final String TEST_DATA_TABLE_STATISTICS_CONSUMPTION = "tdm_benchmark_statistics_consumption";
    private static final UUID projectId = UUID.randomUUID();
    private static final Project project = new Project(){
        {
            this.setName("Test Data Statistics Project");
            this.setId(projectId);
            this.setEnvironments(Collections.singletonList(environment));
        }
    };
    private static CatalogRepository benchmarkCatalogRepository;
    private static StatisticsService benchmarkStatisticsService;
    private static TestDataService benchmarkTestDataService;
    private static EnvironmentsService benchmarkEnvironmentsService;
    private static TestDataTableRepository benchmarkTestDataTableRepository;

    @Test
    public void runBenchmarksToGetStatistics() throws Exception {
        this.setFields();
        Options opts = this.prepareOptionBuilder("jmh-statistics-report.json");
        new Runner(opts).run();
    }

    private void setFields() {
        benchmarkCatalogRepository = this.catalogRepository;
        benchmarkStatisticsService = this.statisticsService;
        benchmarkTestDataService = this.testDataService;
        benchmarkEnvironmentsService = this.environmentsService;
        benchmarkTestDataTableRepository = this.testDataTableRepository;
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public List<GeneralStatisticsItem> getStatisticsAvailability(DataAvailability data) {
        return data.testingTarget.getTestDataAvailability(projectId, systemId);
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public ConsumedStatistics getTestDataConsumption(DataConsumption data) {
        return data.testingTarget.getTestDataConsumption(projectId, systemId);
    }

    @State(value=Scope.Benchmark)
    public static class DataAvailability {
        private StatisticsFacade testingTarget;

        @Setup
        public void setUp() {
            Mockito.when((Object)benchmarkEnvironmentsService.getFullProject((UUID)ArgumentMatchers.any())).thenReturn((Object)project);
            Helper.createTestDataTableCatalog(environmentId, projectId, systemId, "STATISTICS_AVAILABILITY", Statistics.TEST_DATA_TABLE_STATISTICS_AVAILABILITY, benchmarkCatalogRepository);
            this.testingTarget = new StatisticsFacade(benchmarkTestDataService, benchmarkTestDataTableRepository, benchmarkStatisticsService);
            this.testingTarget.createTestDataTable(Statistics.TEST_DATA_TABLE_STATISTICS_AVAILABILITY);
            this.testingTarget.occupyTestData(Statistics.TEST_DATA_TABLE_STATISTICS_AVAILABILITY);
        }
    }

    @State(value=Scope.Benchmark)
    public static class DataConsumption {
        private StatisticsFacade testingTarget;

        @Setup
        public void setUp() {
            Mockito.when((Object)benchmarkEnvironmentsService.getFullProject((UUID)ArgumentMatchers.any())).thenReturn((Object)project);
            Helper.createTestDataTableCatalog(environmentId, projectId, systemId, "STATISTICS_CONSUMPTION", Statistics.TEST_DATA_TABLE_STATISTICS_CONSUMPTION, benchmarkCatalogRepository);
            this.testingTarget = new StatisticsFacade(benchmarkTestDataService, benchmarkTestDataTableRepository, benchmarkStatisticsService);
            this.testingTarget.createTestDataTable(Statistics.TEST_DATA_TABLE_STATISTICS_CONSUMPTION);
            this.testingTarget.occupyTestData(Statistics.TEST_DATA_TABLE_STATISTICS_CONSUMPTION);
        }
    }
}

