/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.benchmarks;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.qubership.atp.tdm.benchmarks.AbstractJmhTest;
import org.qubership.atp.tdm.benchmarks.facades.CleanupDataFacade;
import org.qubership.atp.tdm.benchmarks.utils.Helper;
import org.qubership.atp.tdm.env.configurator.model.Project;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.model.cleanup.CleanupResults;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.CleanupService;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.service.impl.CleanupServiceTest;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest
@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class CleanupData
extends CleanupServiceTest
implements AbstractJmhTest {
    private static final String CLEANUP_TEST_DATA = "tdm_benchmark_cleanup_test_data";
    private static final UUID projectId = UUID.randomUUID();
    private static final Project project = new Project(){
        {
            this.setName("Test Data Cleanup Project");
            this.setId(projectId);
            this.setEnvironments(Collections.singletonList(environment));
        }
    };
    private static TestDataService benchmarkTestDataService;
    private static CleanupService benchmarkCleanupService;
    private static EnvironmentsService benchmarkEnvironmentsService;
    private static TestDataTableRepository benchmarkTestDataTableRepository;
    private static CatalogRepository benchmarkCatalogRepository;

    @Test
    public void runBenchmarksToReleaseData() throws Exception {
        this.setFields();
        Options opts = this.prepareOptionBuilder("jmh-cleanup-data-report.json");
        new Runner(opts).run();
    }

    private void setFields() {
        benchmarkTestDataService = this.testDataService;
        benchmarkCleanupService = this.cleanupService;
        benchmarkEnvironmentsService = this.environmentsService;
        benchmarkCatalogRepository = this.catalogRepository;
        benchmarkTestDataTableRepository = this.testDataTableRepository;
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public List<CleanupResults> runCleanup(Data data) throws Exception {
        return data.testingTarget.runCleanup(CLEANUP_TEST_DATA);
    }

    @State(value=Scope.Benchmark)
    public static class Data {
        private CleanupDataFacade testingTarget;

        @Setup
        public void setUp() {
            Mockito.when((Object)benchmarkEnvironmentsService.getFullProject((UUID)ArgumentMatchers.any())).thenReturn((Object)project);
            Helper.createTestDataTableCatalog(environmentId, projectId, systemId, "CLEANUP_TEST_DATA", CleanupData.CLEANUP_TEST_DATA, benchmarkCatalogRepository);
            this.testingTarget = new CleanupDataFacade(benchmarkTestDataService, benchmarkTestDataTableRepository, benchmarkCleanupService);
            this.testingTarget.createTestDataTable(CleanupData.CLEANUP_TEST_DATA);
        }

        @TearDown
        public void tearDown() {
            benchmarkCatalogRepository.deleteByTableName(CleanupData.CLEANUP_TEST_DATA);
        }
    }
}

