/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.benchmarks;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.benchmarks.AbstractJmhTest;
import org.qubership.atp.tdm.benchmarks.facades.GeneralFacade;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.TestDataService;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest
@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class ExportData
extends AbstractTestDataTest
implements AbstractJmhTest {
    private static final String TEST_DATA_TABLE_EXPORT_AS_EXCEL = "tdm_benchmark_test_data_export_excel";
    private static final String TEST_DATA_TABLE_EXPORT_AS_CSV = "tdm_benchmark_test_data_export_csv";
    private static TestDataService benchmarkTestDataService;
    private static TestDataTableRepository benchmarkTestDataTableRepository;

    @Test
    public void runBenchmarksToExportData() throws Exception {
        this.setFields();
        Options opts = this.prepareOptionBuilder("jmh-export-data-report.json");
        new Runner(opts).run();
    }

    private void setFields() {
        benchmarkTestDataService = this.testDataService;
        benchmarkTestDataTableRepository = this.testDataTableRepository;
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public File getTestDataTableAsExcelFile(GetDataAsExcel data) throws IOException {
        return data.testingTarget.getTestDataTableAsExcelFile(TEST_DATA_TABLE_EXPORT_AS_EXCEL);
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public File getTestDataTableAsCsvFile(GetDataAsCsv data) throws IOException {
        return data.testingTarget.getTestDataTableAsCsvFile(TEST_DATA_TABLE_EXPORT_AS_CSV);
    }

    @State(value=Scope.Benchmark)
    public static class GetDataAsExcel {
        private GeneralFacade testingTarget;

        @Setup
        public void setUp() {
            this.testingTarget = new GeneralFacade(benchmarkTestDataService, benchmarkTestDataTableRepository);
            this.testingTarget.createTestDataTable(ExportData.TEST_DATA_TABLE_EXPORT_AS_EXCEL);
        }
    }

    @State(value=Scope.Benchmark)
    public static class GetDataAsCsv {
        private GeneralFacade testingTarget;

        @Setup
        public void setUp() {
            this.testingTarget = new GeneralFacade(benchmarkTestDataService, benchmarkTestDataTableRepository);
            this.testingTarget.createTestDataTable(ExportData.TEST_DATA_TABLE_EXPORT_AS_CSV);
        }
    }
}

