/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.benchmarks;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.benchmarks.AbstractJmhTest;
import org.qubership.atp.tdm.benchmarks.facades.GeneralFacade;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.TestDataService;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest
@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class ReleaseData
extends AbstractTestDataTest
implements AbstractJmhTest {
    private static final String RELEASE_TEST_DATA = "tdm_benchmark_release_test_data";
    private static TestDataService benchmarkTestDataService;
    private static TestDataTableRepository benchmarkTestDataTableRepository;

    @Test
    public void runBenchmarksToReleaseData() throws Exception {
        this.setFields();
        Options opts = this.prepareOptionBuilder("jmh-release-data-report.json");
        new Runner(opts).run();
    }

    private void setFields() {
        benchmarkTestDataService = this.testDataService;
        benchmarkTestDataTableRepository = this.testDataTableRepository;
    }

    @Benchmark
    @Warmup(iterations=2, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=8, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public String releaseTestData(Data data) {
        return data.testingTarget.releaseTestData(RELEASE_TEST_DATA);
    }

    @State(value=Scope.Benchmark)
    public static class Data {
        private GeneralFacade testingTarget;

        @Setup
        public void setUp() {
            this.testingTarget = new GeneralFacade(benchmarkTestDataService, benchmarkTestDataTableRepository);
            this.testingTarget.createTestDataTable(ReleaseData.RELEASE_TEST_DATA);
            this.testingTarget.occupyTestData(ReleaseData.RELEASE_TEST_DATA);
        }
    }
}

