/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.benchmarks.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.cleanup.CleanupSettings;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumnIdentity;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.service.CleanupService;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class Helper {
    private static final String RESOURCES_PATH = "src/test/resources/";

    public static List<TestDataTableColumn> getTestDataTableColumns(List<String> columnNames) {
        return columnNames.stream().map(columnName -> new TestDataTableColumn(new TestDataTableColumnIdentity("", columnName))).collect(Collectors.toList());
    }

    public static List<UUID> extractRowIds(List<Map<String, Object>> data) {
        return data.stream().map(row -> UUID.fromString(String.valueOf(row.get("ROW_ID")))).collect(Collectors.toList());
    }

    public static File getResourcesFile(String fileName) {
        return new File(RESOURCES_PATH + fileName);
    }

    public static MultipartFile toMultipartFile(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        return new MockMultipartFile("file", file.getName(), "application/vnd.ms-excel", IOUtils.toByteArray((InputStream)input));
    }

    public static Map<String, Object> buildTestDataTableRow(List<String> columnNames, List<String> values) {
        return IntStream.range(0, columnNames.size()).boxed().collect(Collectors.toMap(columnNames::get, values::get));
    }

    public static void createTestDataTableCatalog(@Nullable UUID environmentId, @Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle, @Nonnull String tableName, @Nonnull CatalogRepository catalogRepository) {
        TestDataTableCatalog catalog = new TestDataTableCatalog(tableName, environmentId, projectId, systemId, tableTitle);
        catalogRepository.save((Object)catalog);
    }

    public static TestDataCleanupConfig createTestDataCleanupConfig(@Nonnull CleanupService cleanupService, @Nonnull String tableName, boolean shared) throws Exception {
        TestDataCleanupConfig cleanup = new TestDataCleanupConfig();
        cleanup.setEnabled(true);
        cleanup.setSchedule("0 0/1 * * * ?");
        cleanup.setSearchSql("select * from test_data_table_catalog where table_title = ${'Partner'}");
        cleanup.setShared(shared);
        CleanupSettings cleanupSettings = new CleanupSettings();
        cleanupSettings.setTestDataCleanupConfig(cleanup);
        cleanupSettings.setTableName(tableName);
        return cleanupService.saveCleanupConfig(cleanupSettings).getTestDataCleanupConfig();
    }
}

