/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.benchmarks.facades;

import clover.org.apache.commons.lang.RandomStringUtils;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.qubership.atp.tdm.benchmarks.utils.Helper;
import org.qubership.atp.tdm.model.ImportTestDataStatistic;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.repo.impl.loader.TestDataExcelLoader;
import org.qubership.atp.tdm.service.TestDataService;
import org.springframework.web.multipart.MultipartFile;

public class GeneralFacade {
    private static final String TEST_DATA_TABLE_DEFAULT = "tdm_benchmark_test_data_default";
    public static final String TEST_DATA_SEARCH_VALUE = "8901260720040140973";
    protected TestDataService testDataService;
    protected TestDataTableRepository testDataTableRepository;

    public GeneralFacade(@Nonnull TestDataService testDataService, @Nonnull TestDataTableRepository testDataTableRepository) {
        this.testDataService = testDataService;
        this.testDataTableRepository = testDataTableRepository;
    }

    public void createTestDataTable(String tableName) {
        tableName = Strings.isNullOrEmpty((String)tableName) ? TEST_DATA_TABLE_DEFAULT : tableName;
        this.testDataTableRepository.saveTestData(tableName, false, this.buildTestDataTableWithSpecificData());
    }

    public String occupyTestData(String tableName) {
        tableName = Strings.isNullOrEmpty((String)tableName) ? TEST_DATA_TABLE_DEFAULT : tableName;
        TestDataTable table = this.testDataService.getTestData(tableName);
        List<UUID> rowIdsToOccupy = Helper.extractRowIds(table.getData().subList(0, 5));
        this.testDataService.occupyTestData(tableName, "TestUser", rowIdsToOccupy);
        return "Finished";
    }

    public String releaseTestData(String tableName) {
        tableName = Strings.isNullOrEmpty((String)tableName) ? TEST_DATA_TABLE_DEFAULT : tableName;
        TestDataTable table = this.testDataService.getTestData(tableName);
        List<UUID> rowIdsToRelease = Helper.extractRowIds(table.getData().subList(0, 5));
        this.testDataService.releaseTestData(tableName, rowIdsToRelease);
        return "Finished";
    }

    public File getTestDataTableAsExcelFile(String tableName) throws IOException {
        return this.testDataService.getTestDataTableAsExcelFile(tableName);
    }

    public File getTestDataTableAsCsvFile(String tableName) throws IOException {
        return this.testDataService.getTestDataTableAsCsvFile(tableName);
    }

    protected TestDataTable buildTestDataTableWithSpecificData() {
        String number;
        int i;
        TestDataTable table = new TestDataTable();
        List<String> columns = Arrays.asList("SIM", "Status", "Partner", "Partner category", "Partner ID", "Operator ID", "Environment", "Assignment");
        table.setColumns(Helper.getTestDataTableColumns(columns));
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (i = 0; i < 499; ++i) {
            number = RandomStringUtils.random((int)19, (boolean)false, (boolean)true);
            data.add(Helper.buildTestDataTableRow(columns, Arrays.asList(number, "51", "CINTEX", "MVNO", "1", "2500", "ZLAB08", "Test Automation")));
        }
        data.add(Helper.buildTestDataTableRow(columns, Arrays.asList(TEST_DATA_SEARCH_VALUE, "51", "CINTEX", "MVNO", "1", "2500", "ZLAB08", "Test Automation")));
        for (i = 0; i < 500; ++i) {
            number = RandomStringUtils.random((int)19, (boolean)false, (boolean)true);
            data.add(Helper.buildTestDataTableRow(columns, Arrays.asList(number, "51", "CINTEX", "MVNO", "1", "2500", "ZLAB08", "Test Automation")));
        }
        table.setData(data);
        table.setRecords(1000);
        return table;
    }

    public TestDataTable importExcelTestData(@Nonnull String fileName) throws IOException {
        TestDataTable testDataTable;
        block8: {
            MultipartFile file = Helper.toMultipartFile(Helper.getResourcesFile(fileName));
            OPCPackage opcPackage = OPCPackage.open((InputStream)file.getInputStream());
            try {
                TestDataExcelLoader loader = new TestDataExcelLoader(opcPackage);
                testDataTable = loader.process();
                if (opcPackage == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (opcPackage != null) {
                        try {
                            opcPackage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            opcPackage.close();
        }
        return testDataTable;
    }

    public List<ImportTestDataStatistic> importExcelTestDataViaService(@Nonnull String fileName, @Nonnull String tableTitle) throws IOException {
        return this.testDataService.importExcelTestData(UUID.randomUUID(), null, null, tableTitle, Boolean.valueOf(false), Helper.toMultipartFile(Helper.getResourcesFile(fileName)));
    }

    public List<ImportTestDataStatistic> importSqlTestData(@Nonnull UUID environmentId, @Nonnull String tableTitle, @Nonnull String sourceTable) {
        return this.testDataService.importSqlTestData(UUID.randomUUID(), Collections.singletonList(environmentId), "Test System", tableTitle, "select SIM from " + sourceTable, Integer.valueOf(30));
    }
}

