/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.env.configurator.model;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvSearchSystemByIdException;
import org.qubership.atp.tdm.env.configurator.model.AbstractConfiguratorModel;
import org.qubership.atp.tdm.env.configurator.model.Environment;
import org.qubership.atp.tdm.env.configurator.model.LazyProject;
import org.qubership.atp.tdm.env.configurator.model.System;

public class Project
extends AbstractConfiguratorModel {
    private String shortName;
    private List<Environment> environments;

    public Environment getEnvironmentByName(String id) throws NoSuchElementException {
        return this.getByName(this.environments, id);
    }

    public Environment getEnvironmentById(UUID id) throws NoSuchElementException {
        return this.getById(this.environments, id);
    }

    public static Project of(LazyProject lazyProject, List<Environment> environments) {
        Project project = new Project();
        project.setId(lazyProject.getId());
        project.setName(lazyProject.getName());
        project.setEnvironments(environments);
        return project;
    }

    public System getSystemById(@Nonnull UUID systemId) {
        return this.getEnvironments().stream().flatMap(environment -> environment.getSystems().stream()).filter(system -> system.getId().equals(systemId)).findFirst().orElseThrow(() -> new TdmEnvSearchSystemByIdException(systemId.toString()));
    }

    public List<System> getSystems() {
        return this.getEnvironments().stream().flatMap(environment -> environment.getSystems().stream()).collect(Collectors.toList());
    }

    public static ProjectBuilder builder() {
        return new ProjectBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$shortName = this.getShortName();
        String other$shortName = other.getShortName();
        if (this$shortName == null ? other$shortName != null : !this$shortName.equals(other$shortName)) {
            return false;
        }
        List<Environment> this$environments = this.getEnvironments();
        List<Environment> other$environments = other.getEnvironments();
        return !(this$environments == null ? other$environments != null : !((Object)this$environments).equals(other$environments));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $shortName = this.getShortName();
        result = result * 59 + ($shortName == null ? 43 : $shortName.hashCode());
        List<Environment> $environments = this.getEnvironments();
        result = result * 59 + ($environments == null ? 43 : ((Object)$environments).hashCode());
        return result;
    }

    public String getShortName() {
        return this.shortName;
    }

    public List<Environment> getEnvironments() {
        return this.environments;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setEnvironments(List<Environment> environments) {
        this.environments = environments;
    }

    @Override
    public String toString() {
        return "Project(shortName=" + this.getShortName() + ", environments=" + this.getEnvironments() + ")";
    }

    public Project() {
    }

    public Project(String shortName, List<Environment> environments) {
        this.shortName = shortName;
        this.environments = environments;
    }

    public static class ProjectBuilder {
        private String shortName;
        private List<Environment> environments;

        ProjectBuilder() {
        }

        public ProjectBuilder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public ProjectBuilder environments(List<Environment> environments) {
            this.environments = environments;
            return this;
        }

        public Project build() {
            return new Project(this.shortName, this.environments);
        }

        public String toString() {
            return "Project.ProjectBuilder(shortName=" + this.shortName + ", environments=" + this.environments + ")";
        }
    }
}

