/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.env.configurator.configuration;

import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvInitiateCacheException;
import org.qubership.atp.tdm.env.configurator.utils.CacheNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableAutoConfiguration
public class EnvironmentsConfig {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsConfig.class);
    @Value(value="${environments.cache.duration:15}")
    private Integer cacheDuration;

    @Bean
    @ConditionalOnProperty(name={"spring.cache.type"}, havingValue="GENERIC")
    public CacheManager cacheManager() {
        log.info("Environments cache manage is enabled. Cache duration: {}", (Object)this.cacheDuration);
        ConcurrentMapCacheManager cacheManager = new ConcurrentMapCacheManager(){

            protected Cache createConcurrentMapCache(String name) {
                return new ConcurrentMapCache(name, CacheBuilder.newBuilder().expireAfterWrite((long)EnvironmentsConfig.this.cacheDuration.intValue(), TimeUnit.MINUTES).build().asMap(), false);
            }
        };
        ArrayList<String> cacheNames = new ArrayList<String>();
        try {
            Field[] fields;
            for (Field field : fields = CacheNames.class.getDeclaredFields()) {
                cacheNames.add(field.get(String.class).toString());
            }
        }
        catch (Exception e) {
            log.error("An error occurred while initiating environment caches.", (Throwable)e);
            throw new TdmEnvInitiateCacheException();
        }
        cacheManager.setCacheNames(cacheNames);
        return cacheManager;
    }
}

