/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.env.configurator.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.tdm.env.configurator.controllers.api.dto.environments.LazyEnvironmentDto;
import org.qubership.atp.tdm.env.configurator.controllers.api.dto.environments.LazyProjectDto;
import org.qubership.atp.tdm.env.configurator.controllers.api.dto.environments.LazySystemDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="EnvironmentsController", description="Environments Controller")
public interface EnvironmentsControllerApi {
    @Operation(operationId="getLazyEnvironments", summary="getLazyEnvironments", tags={"environments-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LazyEnvironmentDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/projects/{projectId}/environments/lazy"}, produces={"application/json"})
    public ResponseEntity<List<LazyEnvironmentDto>> getLazyEnvironments(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getLazySystems", summary="getLazySystems", tags={"environments-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LazySystemDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/environments/{environmentId}/systems/lazy"}, produces={"application/json"})
    public ResponseEntity<List<LazySystemDto>> getLazySystems(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="getProjects", summary="getProjects", tags={"environments-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LazyProjectDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/projects/lazy"}, produces={"application/json"})
    public ResponseEntity<List<LazyProjectDto>> getProjects();

    @Operation(operationId="resetCaches", summary="resetCaches", tags={"environments-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/envs/reset/caches"}, produces={"application/json"})
    public ResponseEntity<Boolean> resetCaches();
}

