/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.env.configurator.model;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.qubership.atp.tdm.env.configurator.model.AbstractConfiguratorModel;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.model.System;

public class Environment
extends AbstractConfiguratorModel {
    private UUID projectId;
    private List<System> systems;

    public System getSystemByName(String name) throws NoSuchElementException {
        return this.getByName(this.systems, name);
    }

    public System getSystemById(UUID id) throws NoSuchElementException {
        return this.getById(this.systems, id);
    }

    public static Environment of(LazyEnvironment lazyEnvironment, List<System> systems) {
        Environment environment = new Environment();
        environment.setId(lazyEnvironment.getId());
        environment.setName(lazyEnvironment.getName());
        environment.setDescription(lazyEnvironment.getDescription());
        environment.setCreated(lazyEnvironment.getCreated());
        environment.setCreatedBy(lazyEnvironment.getCreatedBy());
        environment.setModified(lazyEnvironment.getModified());
        environment.setModifiedBy(lazyEnvironment.getModifiedBy());
        environment.setSystems(systems);
        return environment;
    }

    public static EnvironmentBuilder builder() {
        return new EnvironmentBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        List<System> this$systems = this.getSystems();
        List<System> other$systems = other.getSystems();
        return !(this$systems == null ? other$systems != null : !((Object)this$systems).equals(other$systems));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Environment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        List<System> $systems = this.getSystems();
        result = result * 59 + ($systems == null ? 43 : ((Object)$systems).hashCode());
        return result;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public List<System> getSystems() {
        return this.systems;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setSystems(List<System> systems) {
        this.systems = systems;
    }

    @Override
    public String toString() {
        return "Environment(projectId=" + this.getProjectId() + ", systems=" + this.getSystems() + ")";
    }

    public Environment() {
    }

    public Environment(UUID projectId, List<System> systems) {
        this.projectId = projectId;
        this.systems = systems;
    }

    public static class EnvironmentBuilder {
        private UUID projectId;
        private List<System> systems;

        EnvironmentBuilder() {
        }

        public EnvironmentBuilder projectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        public EnvironmentBuilder systems(List<System> systems) {
            this.systems = systems;
            return this;
        }

        public Environment build() {
            return new Environment(this.projectId, this.systems);
        }

        public String toString() {
            return "Environment.EnvironmentBuilder(projectId=" + this.projectId + ", systems=" + this.systems + ")";
        }
    }
}

