/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.env.configurator.model;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.tdm.env.configurator.model.Connection;

public class Server {
    private static final int MILLISECONDS = 1000;
    private final Connection connection;
    private final String name;

    public Server(Connection connection, String name) {
        this.name = name;
        this.connection = connection;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.getProperty(this.name + "_login");
    }

    public String getPass() {
        return this.getProperty(this.name + "_password");
    }

    public String getKey() {
        return this.getProperty(this.name + "_key");
    }

    public String getPassPhrase() {
        return this.getProperty(this.name + "_passphrase");
    }

    public boolean getPty() {
        String pty = this.getProperty(this.name + "_pty");
        if (pty != null) {
            try {
                return Boolean.parseBoolean(pty);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public int getTimeoutConnect() {
        return this.getTimeout("connect", 60000);
    }

    public int getTimeoutExecute() {
        return this.getTimeout("execute", 3600000);
    }

    public String getProperty(String key) {
        return this.connection.getParameters().get(key);
    }

    public Map<String, String> getProperties() {
        return this.connection.getParameters();
    }

    public String getHostFull() {
        return this.getProperty(this.name + "_host");
    }

    public String getHost() {
        Pattern pattern = Pattern.compile("([^:^]*)(:\\d*)?(.*)?");
        Matcher matcher = pattern.matcher(this.getHostFull());
        matcher.find();
        String host = matcher.group(1);
        return host;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Server server = (Server)o;
        return Objects.equals(this.connection, server.connection) && Objects.equals(this.name, server.name);
    }

    public int hashCode() {
        return Objects.hash(this.connection, this.name);
    }

    private int getTimeout(String timeoutPostfix, int defaultValue) {
        String timeout = this.getProperty(this.name + "_timeout_" + timeoutPostfix);
        if (timeout != null) {
            try {
                return Integer.parseInt(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

