/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.env.configurator.controllers;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.model.LazyProject;
import org.qubership.atp.tdm.env.configurator.model.LazySystem;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/tdm/"})
@RestController
public class EnvironmentsController {
    private EnvironmentsService service;

    @Autowired
    public EnvironmentsController(EnvironmentsService service) {
        this.service = service;
    }

    @AuditAction(auditAction="Get lazy projects")
    @GetMapping(value={"/projects/lazy"})
    public List<LazyProject> getProjects() {
        return this.service.getLazyProjects();
    }

    @AuditAction(auditAction="Get lazy environment by projectId {{#projectId}}")
    @GetMapping(value={"/projects/{projectId}/environments/lazy"})
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, 'READ')")
    public List<LazyEnvironment> getLazyEnvironments(@PathVariable UUID projectId) {
        return this.service.getLazyEnvironments(projectId);
    }

    @AuditAction(auditAction="Get lazy system by environmentId {{#environmentId}}")
    @GetMapping(value={"/environments/{environmentId}/systems/lazy"})
    public List<LazySystem> getLazySystems(@PathVariable UUID environmentId) {
        return this.service.getLazySystems(environmentId, "Default");
    }

    @AuditAction(auditAction="Reset caches")
    @GetMapping(value={"/envs/reset/caches"})
    public boolean resetCaches() {
        return this.service.resetCaches();
    }
}

