/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.exception;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.exception.ConstraintViolationException;
import org.postgresql.util.PSQLException;
import org.postgresql.util.ServerErrorMessage;
import org.qubership.integration.platform.catalog.consul.exception.ConsulException;
import org.qubership.integration.platform.catalog.consul.exception.TxnConflictException;
import org.qubership.integration.platform.catalog.exception.CatalogRuntimeException;
import org.qubership.integration.platform.catalog.exception.ChainDifferenceClientException;
import org.qubership.integration.platform.catalog.exception.ChainDifferenceException;
import org.qubership.integration.platform.catalog.exception.ComparisonEntityNotFoundException;
import org.qubership.integration.platform.catalog.exception.ImportInstructionsExternalException;
import org.qubership.integration.platform.catalog.exception.ImportInstructionsInternalException;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.exception.SpecificationImportException;
import org.qubership.integration.platform.catalog.exception.SpecificationImportWarningException;
import org.qubership.integration.platform.designtime.catalog.exception.ExceptionDTO;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.BadRequestException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ChainMigrationException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ChainModificationException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.EnvironmentSetUpException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.FolderMoveException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ImportInstructionsValidationException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.KubeApiException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.MicroserviceConnectivityException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.SpecificationNotFoundException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.SpecificationProtocolDifferentException;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.TemplateDataBuilderException;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.exception.DetailedDesignInternalException;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.exception.TemplateDataEscapingException;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.exception.TemplateProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String NO_STACKTRACE_AVAILABLE_MESSAGE = "No Stacktrace Available, check the logs for more details.";

    @ExceptionHandler
    public ResponseEntity<ExceptionDTO> handleGeneralException(Exception exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<ExceptionDTO> handleEntityNotFoundException() {
        return ResponseEntity.notFound().build();
    }

    @ExceptionHandler(value={SpecificationNotFoundException.class})
    public ResponseEntity<ExceptionDTO> handleSpecificationNotFoundException() {
        return ResponseEntity.notFound().build();
    }

    @ExceptionHandler(value={SpecificationImportException.class, IOException.class})
    public ResponseEntity<ExceptionDTO> handleImportException(CatalogRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={SpecificationImportWarningException.class})
    public ResponseEntity<ExceptionDTO> handleImportWarningException(CatalogRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={SpecificationProtocolDifferentException.class})
    public ResponseEntity<ExceptionDTO> handleProtocolException(CatalogRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={BadRequestException.class})
    public ResponseEntity<ExceptionDTO> handleBadRequestException(CatalogRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={EnvironmentSetUpException.class})
    public ResponseEntity<ExceptionDTO> handleEnvironmentSetUpException(CatalogRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={MicroserviceConnectivityException.class})
    public ResponseEntity<ExceptionDTO> handleMicroserviceConnectivityException(CatalogRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={KubeApiException.class})
    public ResponseEntity<ExceptionDTO> handleApiException(CatalogRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={EntityExistsException.class})
    public ResponseEntity<ExceptionDTO> handleEntityExistsException(EntityExistsException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={SnapshotCreationException.class})
    public ResponseEntity<ExceptionDTO> handleSnapshotCreationException(SnapshotCreationException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={ChainMigrationException.class})
    public ResponseEntity<ExceptionDTO> handleChainMigrationException(ChainMigrationException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={ChainModificationException.class})
    public ResponseEntity<ExceptionDTO> handleChainModificationException(ChainModificationException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={FolderMoveException.class})
    public ResponseEntity<ExceptionDTO> handleFolderMoveException(FolderMoveException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<ExceptionDTO> handleFolderMoveException(IllegalArgumentException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={TxnConflictException.class})
    public ResponseEntity<ExceptionDTO> handleTxnConflictException(TxnConflictException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={ComparisonEntityNotFoundException.class})
    public ResponseEntity<ExceptionDTO> handleComparisonEntityNotFoundException(ComparisonEntityNotFoundException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={ChainDifferenceClientException.class})
    public ResponseEntity<ExceptionDTO> handleChainDifferenceClientException(ChainDifferenceClientException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={ChainDifferenceException.class})
    public ResponseEntity<ExceptionDTO> handleChainDifferenceException(ChainDifferenceException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={ConsulException.class})
    public ResponseEntity<ExceptionDTO> handleConsulException(ConsulException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={DetailedDesignInternalException.class})
    public ResponseEntity<ExceptionDTO> handleConsulException(DetailedDesignInternalException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={TemplateDataBuilderException.class})
    public ResponseEntity<ExceptionDTO> handleConsulException(TemplateDataBuilderException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={TemplateDataEscapingException.class})
    public ResponseEntity<ExceptionDTO> handleConsulException(TemplateDataEscapingException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={TemplateProcessingException.class})
    public ResponseEntity<ExceptionDTO> handleConsulException(TemplateProcessingException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={ImportInstructionsInternalException.class})
    public ResponseEntity<ExceptionDTO> handleImportInstructionsInternalException(ImportInstructionsInternalException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={ImportInstructionsExternalException.class})
    public ResponseEntity<ExceptionDTO> handleImportInstructionsExternalException(ImportInstructionsExternalException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={jakarta.validation.ConstraintViolationException.class})
    public ResponseEntity<ExceptionDTO> handleConstraintViolationException(jakarta.validation.ConstraintViolationException exception) {
        String errorMessage = exception.getConstraintViolations().stream().map(violation -> violation.getPropertyPath().toString() + " " + violation.getMessage()).collect(Collectors.joining(", ", "Invalid request content: [", "]"));
        ExceptionDTO exceptionDTO = ExceptionDTO.builder().errorMessage(errorMessage).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)exceptionDTO);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        String errorMessage = ex.getBindingResult().getAllErrors().stream().map(error -> {
            if (error instanceof FieldError) {
                FieldError fieldError = (FieldError)error;
                return fieldError.getField() + " " + fieldError.getDefaultMessage();
            }
            return error.getDefaultMessage();
        }).collect(Collectors.joining(", ", "Invalid request content: [", "]"));
        ExceptionDTO exceptionDTO = ExceptionDTO.builder().errorMessage(errorMessage).errorDate(new Timestamp(System.currentTimeMillis()).toString()).stacktrace(NO_STACKTRACE_AVAILABLE_MESSAGE).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)exceptionDTO);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public ResponseEntity<ExceptionDTO> handleDataIntegrityViolationException(DataIntegrityViolationException exception) {
        Throwable throwable = exception.getCause();
        if (throwable instanceof ConstraintViolationException) {
            ConstraintViolationException constraintException = (ConstraintViolationException)throwable;
            if ("import_instructions_unique_override_idx".equals(constraintException.getConstraintName())) {
                return this.handleImportInstructionsExternalException((ImportInstructionsExternalException)new ImportInstructionsValidationException(this.extractConstraintMessage(constraintException)));
            }
            if ("overridden_by_id_only_for_override".equals(constraintException.getConstraintName())) {
                return this.handleImportInstructionsExternalException((ImportInstructionsExternalException)new ImportInstructionsValidationException("Overridden By must not be specified for instruction with non OVERRIDE action"));
            }
        }
        return this.handleGeneralException((Exception)exception);
    }

    private ExceptionDTO getExceptionDTO(Exception exception) {
        String message = exception.getMessage();
        String stacktrace = NO_STACKTRACE_AVAILABLE_MESSAGE;
        if (exception instanceof CatalogRuntimeException) {
            CatalogRuntimeException catalogRuntimeException = (CatalogRuntimeException)exception;
            if (catalogRuntimeException.getOriginalException() != null) {
                stacktrace = ExceptionUtils.getStackTrace((Throwable)catalogRuntimeException.getOriginalException());
            }
        } else if (!(exception instanceof FolderMoveException)) {
            stacktrace = ExceptionUtils.getStackTrace((Throwable)exception);
        }
        log.error("An error occurred: {}. Stacktrace: {}", (Object)message, (Object)stacktrace);
        return ExceptionDTO.builder().errorMessage(message).stacktrace(NO_STACKTRACE_AVAILABLE_MESSAGE).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
    }

    private ExceptionDTO getExceptionDTOWithoutStacktrace(Exception exception) {
        String message = exception.getMessage();
        return ExceptionDTO.builder().errorMessage(message).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
    }

    private String extractConstraintMessage(ConstraintViolationException exception) {
        Optional<ServerErrorMessage> serverErrorMessage = Optional.empty();
        SQLException sQLException = exception.getSQLException();
        if (sQLException instanceof PSQLException) {
            PSQLException psqlException = (PSQLException)sQLException;
            serverErrorMessage = Optional.ofNullable(psqlException.getServerErrorMessage());
        } else if (exception.getSQLException() != null && (sQLException = exception.getSQLException().getNextException()) instanceof PSQLException) {
            PSQLException psqlException = (PSQLException)sQLException;
            serverErrorMessage = Optional.ofNullable(psqlException.getServerErrorMessage());
        }
        return serverErrorMessage.map(errorMessage -> errorMessage.getDetail() + " already overrides or overridden by another chain").orElse("Instruction for the chain already exist");
    }
}

