/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.kubernetes;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.openapi.models.V1ServicePort;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.KubeApiException;
import org.qubership.integration.platform.designtime.catalog.model.kubernetes.KubeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubeOperator.class);
    private static final String DEFAULT_ERR_MESSAGE = "Invalid k8s cluster parameters or API error. ";
    private static final String REGEX_FOR_SEARCH_BLUEGREEN_SERVICE_NAME = ".*-v\\d+$";
    private final CoreV1Api coreApi = new CoreV1Api();
    private final AppsV1Api appsApi;
    private final String namespace;

    public KubeOperator() {
        this.appsApi = new AppsV1Api();
        this.namespace = null;
    }

    public KubeOperator(ApiClient client, String namespace) {
        this.coreApi.setApiClient(client);
        this.appsApi = new AppsV1Api();
        this.appsApi.setApiClient(client);
        this.namespace = namespace;
    }

    public List<KubeService> getServices() {
        try {
            V1ServiceList list = this.coreApi.listNamespacedService(this.namespace, null, null, null, null, null, null, null, null, null, null, null);
            return list.getItems().stream().filter(item -> !Objects.requireNonNull(Objects.requireNonNull(item.getMetadata()).getName()).matches(REGEX_FOR_SEARCH_BLUEGREEN_SERVICE_NAME)).map(item -> KubeService.builder().id(Objects.requireNonNull(Objects.requireNonNull(item.getMetadata()).getUid())).name(Objects.requireNonNull(item.getMetadata().getName())).namespace(this.namespace).ports(Objects.requireNonNull(Objects.requireNonNull(item.getSpec()).getPorts()).stream().map(V1ServicePort::getPort).collect(Collectors.toList())).build()).collect(Collectors.toList());
        }
        catch (ApiException e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getResponseBody());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getResponseBody(), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getMessage());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getMessage(), e);
        }
    }
}

