/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.qubership.integration.platform.catalog.model.dto.dependency.DependencyResponse;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.designtime.catalog.model.ChainDiff;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainDiffResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.dependency.DependencyRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainDiffMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.DependencyMapper;
import org.qubership.integration.platform.designtime.catalog.service.DependencyService;
import org.qubership.integration.platform.designtime.catalog.service.ElementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/chains/{chainId}/dependencies"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="dependency-controller", description="Dependency Controller")
public class DependencyController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependencyController.class);
    private final DependencyService dependencyService;
    private final DependencyMapper dependencyMapper;
    private final ChainDiffMapper chainDiffMapper;
    private final ElementService elementService;

    @Autowired
    public DependencyController(DependencyService dependencyService, DependencyMapper dependencyMapper, ChainDiffMapper chainDiffMapper, ElementService elementService) {
        this.dependencyService = dependencyService;
        this.dependencyMapper = dependencyMapper;
        this.chainDiffMapper = chainDiffMapper;
        this.elementService = elementService;
    }

    @GetMapping
    @Operation(description="Find all dependencies by chain")
    public ResponseEntity<List<DependencyResponse>> findAllByChainId(@PathVariable @Parameter(description="Chain id") String chainId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to receive dependencies from chain: {}", (Object)chainId);
        }
        List elements = this.elementService.findAllByChainId(chainId);
        List response = this.dependencyMapper.extractDependencies(elements);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{dependencyId}"})
    @Operation(description="Find specific dependency in the chain")
    public ResponseEntity<DependencyResponse> findById(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Dependency id") String dependencyId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find dependency {} in chain {}", (Object)chainId, (Object)dependencyId);
        }
        Dependency entity = this.dependencyService.findById(dependencyId);
        DependencyResponse response = this.dependencyMapper.asResponse(entity);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    @Operation(description="Create new dependency for the chain")
    public ResponseEntity<ChainDiffResponse> create(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Parameter(description="Dependency object") DependencyRequest request) {
        this.logCreation(chainId, request);
        String from = request.getFrom();
        String to = request.getTo();
        ChainDiff chainDiff = this.dependencyService.create(from, to);
        ChainDiffResponse response = this.chainDiffMapper.asResponse(chainDiff);
        return ResponseEntity.ok((Object)response);
    }

    @Deprecated
    @DeleteMapping(value={"/{dependencyId}"})
    @Operation(description="Delete specific dependency in the chain")
    public ResponseEntity<ChainDiffResponse> deleteById(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Dependency id") String dependencyId) {
        log.info("Request to delete dependency {} from chain {}", (Object)dependencyId, (Object)chainId);
        ChainDiff chainDiff = this.dependencyService.deleteById(dependencyId);
        ChainDiffResponse response = this.chainDiffMapper.asResponse(chainDiff);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={""})
    @Operation(description="Delete specified dependencies in the chain")
    public ResponseEntity<ChainDiffResponse> deleteByIds(@PathVariable @Parameter(description="Chain id") String chainId, @RequestParam @Parameter(description="Dependency ids separated by comma") List<String> dependenciesIds) {
        log.info("Request to delete dependencies {} from chain {}", dependenciesIds, (Object)chainId);
        ChainDiff chainDiff = this.dependencyService.deleteAllByIds(dependenciesIds);
        ChainDiffResponse response = this.chainDiffMapper.asResponse(chainDiff);
        return ResponseEntity.ok((Object)response);
    }

    private void logCreation(String chainId, DependencyRequest dependency) {
        String from = dependency.getFrom();
        String to = dependency.getTo();
        log.info("Request to add dependency from {} to {} in chain {}", new Object[]{from, to, chainId});
    }
}

