/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.DetailedDesignTemplate;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.dds.DDSResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.dds.DDSTemplateCreateRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.dds.DDSTemplateResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.DetailedDesignMapper;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.DetailedDesignService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/detailed-design"}, produces={"application/json"})
@Tag(name="detailed-design-controller", description="Detailed Design Controller")
@CrossOrigin(origins={"*"})
public class DetailedDesignController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DetailedDesignController.class);
    private final DetailedDesignService detailedDesignService;
    private final DetailedDesignMapper detailedDesignMapper;

    @Autowired
    public DetailedDesignController(DetailedDesignService detailedDesignService, DetailedDesignMapper detailedDesignMapper) {
        this.detailedDesignService = detailedDesignService;
        this.detailedDesignMapper = detailedDesignMapper;
    }

    @GetMapping(value={"/chains/{chainId}"})
    @Operation(description="Get chain detailed design by chainId and templateId")
    public ResponseEntity<DDSResponse> getChainDesign(@PathVariable(value="chainId") String chainId, @RequestParam(value="templateId") String templateId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to generate detailed design for chain: {}, by template: {}", (Object)chainId, (Object)templateId);
        }
        return ResponseEntity.ok((Object)this.detailedDesignService.buildChainDetailedDesign(chainId, templateId));
    }

    @GetMapping(value={"/templates/{templateId}"})
    @Operation(description="Get detailed design template by id")
    public ResponseEntity<DDSTemplateResponse> getTemplate(@PathVariable(value="templateId") String templateId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get detailed design template: {}", (Object)templateId);
        }
        return ResponseEntity.ok((Object)this.detailedDesignMapper.asResponse(this.detailedDesignService.getTemplate(templateId)));
    }

    @GetMapping(value={"/templates"})
    @Operation(description="Get all detailed design templates")
    public ResponseEntity<List<DDSTemplateResponse>> getTemplates(@RequestParam(defaultValue="true") boolean includeContent) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get detailed design templates");
        }
        List customResponse = this.detailedDesignMapper.asResponses(this.detailedDesignService.findCustomTemplates());
        List builtInResponse = this.detailedDesignMapper.asResponses(this.detailedDesignService.getBuiltInTemplates());
        List<DDSTemplateResponse> result = Stream.concat(customResponse.stream().peek(response -> response.setBuiltIn(Boolean.valueOf(false))), builtInResponse.stream().peek(response -> response.setBuiltIn(Boolean.valueOf(true)))).toList();
        if (!includeContent) {
            result.forEach(template -> template.setContent(null));
        }
        return ResponseEntity.ok(result);
    }

    @PutMapping(value={"/templates"})
    @Operation(description="Create detailed design template")
    public ResponseEntity<DDSTemplateResponse> createTemplate(@RequestBody DDSTemplateCreateRequest request) {
        log.info("Request to create or update detailed design template");
        DetailedDesignTemplate template = this.detailedDesignService.createOrUpdateTemplate(request.getName(), request.getContent());
        return ResponseEntity.ok((Object)this.detailedDesignMapper.asResponse(template));
    }

    @DeleteMapping(value={"/templates"})
    @Operation(description="Delete detailed design template")
    public ResponseEntity<Void> deleteTemplates(@RequestParam(value="ids") List<String> ids) {
        log.info("Request to delete detailed design templates with ids: {}", ids);
        this.detailedDesignService.deleteTemplates(ids);
        return ResponseEntity.noContent().build();
    }
}

