/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.discovery.DiscoveredServiceDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.discovery.DiscoveryResultDTO;
import org.qubership.integration.platform.designtime.catalog.service.DiscoveryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/systems/discovery"}, produces={"application/json"})
@Tag(name="discovery-controller", description="Discovery Controller")
public class DiscoveryController {
    private final DiscoveryService discoveryService;

    @Autowired
    public DiscoveryController(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @GetMapping
    @Operation(description="Get all currently discovered services")
    public List<DiscoveredServiceDTO> getServices() {
        return this.discoveryService.getServices();
    }

    @PostMapping
    @Operation(description="Initiate discovery process on a current environment")
    public Object runDiscovery() {
        this.discoveryService.runDiscovery();
        return ResponseEntity.accepted().build();
    }

    @GetMapping(value={"/result"})
    @Operation(description="Get result of a discovery process initiated earlier")
    public DiscoveryResultDTO getDiscoveryResult() {
        return this.discoveryService.getDiscoveryResult();
    }

    @GetMapping(value={"/progress"})
    @Operation(description="Get status of a discovery process initiated earlier")
    public String getDiscoveryProgress() {
        return this.discoveryService.getDiscoveryProgress();
    }
}

