/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.chain.element.UsedProperty;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.designtime.catalog.model.ChainDiff;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainDiffResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.CloneElementRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.CreateElementRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.ElementResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.ElementWithChainNameResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.ElementsCodeDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.PatchElementRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.TransferElementRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainDiffMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ElementMapper;
import org.qubership.integration.platform.designtime.catalog.service.TransferableElementService;
import org.qubership.integration.platform.designtime.catalog.service.UsedPropertiesAnalyzer;
import org.qubership.integration.platform.designtime.catalog.service.codeview.ElementsCodeviewService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/chains/{chainId}/elements"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="element-controller", description="Element Controller")
public class ElementController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElementController.class);
    private final TransferableElementService transferableElementService;
    private final ElementsCodeviewService elementsCodeviewService;
    private final UsedPropertiesAnalyzer usedPropertiesAnalyzer;
    private final ElementMapper elementMapper;
    private final ChainDiffMapper chainDiffMapper;
    private final ActionsLogService actionLogger;

    @Autowired
    public ElementController(ElementsCodeviewService elementsCodeviewService, ElementMapper elementMapper, ChainDiffMapper chainDiffMapper, ActionsLogService actionLogger, TransferableElementService transferableElementService, UsedPropertiesAnalyzer usedPropertiesAnalyzer) {
        this.elementsCodeviewService = elementsCodeviewService;
        this.elementMapper = elementMapper;
        this.chainDiffMapper = chainDiffMapper;
        this.actionLogger = actionLogger;
        this.transferableElementService = transferableElementService;
        this.usedPropertiesAnalyzer = usedPropertiesAnalyzer;
    }

    @GetMapping(value={"/{elementId}"})
    @Operation(description="Get specific element from the chain")
    public ResponseEntity<ElementResponse> findElementById(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Element id") String elementId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find element with id: {}", (Object)elementId);
        }
        ChainElement element = this.transferableElementService.findById(elementId);
        ElementResponse response = this.elementMapper.toElementResponse(element);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping
    @Operation(description="Get all elements from the chain")
    public ResponseEntity<List<ElementResponse>> getElementsByChainId(@PathVariable @Parameter(description="Chain id") String chainId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find all elements in chain with id: {}", (Object)chainId);
        }
        List elements = this.transferableElementService.findAllByChainId(chainId);
        List responses = this.elementMapper.toElementResponses(elements);
        return ResponseEntity.ok((Object)responses);
    }

    @GetMapping(value={"/type/{type}"})
    @Operation(description="Get all elements of specific type")
    public ResponseEntity<List<ElementWithChainNameResponse>> getElementsWithChainNameByType(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Inner element type") String type) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find all elements with type: {}", (Object)type);
        }
        List elements = this.transferableElementService.findAllElementsWithChainNameByElementType(type);
        List response = this.elementMapper.toElementWithChainNameResponses(elements);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/code"})
    @Operation(description="Get all elements from the chain in code representation for end-user")
    public ResponseEntity<ElementsCodeDTO> getElementsAsCode(@PathVariable @Parameter(description="Chain id") String chainId) {
        return ResponseEntity.ok((Object)this.elementMapper.elementsCodeToDTO(this.elementsCodeviewService.getElementsAsCode(chainId)));
    }

    @Deprecated(forRemoval=true, since="24.2")
    @PostMapping(value={"/code"})
    @Operation(description="Save all elements from the chain in code representation")
    public ResponseEntity<List<ElementResponse>> saveElementsFromCode(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Parameter(description="Code representation from all elements in a chain") ElementsCodeDTO elementsYaml) {
        List elements = this.elementsCodeviewService.saveElementsAsCode(chainId, elementsYaml.getCode());
        List responses = this.elementMapper.toElementResponses(elements);
        return ResponseEntity.ok((Object)responses);
    }

    @GetMapping(value={"/properties/used"})
    @Operation(description="Get used exchange properties in the chain")
    public ResponseEntity<List<UsedProperty>> getElementsUsedProperties(@PathVariable @Parameter(description="Chain id") String chainId) {
        return ResponseEntity.ok((Object)this.usedPropertiesAnalyzer.getUsedProperties(chainId));
    }

    @PostMapping
    @Operation(description="Create element for the chain")
    public ResponseEntity<ChainDiffResponse> createElement(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Parameter(description="Create element request object") CreateElementRequest createRequest) {
        log.info("Request to add new element to chain with id: {}", (Object)chainId);
        ChainDiff chainDiff = this.transferableElementService.create(chainId, createRequest);
        ChainDiffResponse response = this.chainDiffMapper.asResponse(chainDiff);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/groups"})
    @Operation(description="Wrap specific elements from the chain into a group container")
    public ResponseEntity<?> createGroup(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Parameter(description="Element ids of the chain separated by comma") List<String> elements) {
        log.info("Request to wrap elements {} in group", elements);
        try {
            ChainElement containerEntity = this.transferableElementService.group(chainId, elements);
            ElementResponse response = this.elementMapper.toElementResponse(containerEntity);
            return ResponseEntity.ok((Object)response);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/clone"})
    @Operation(description="Copy specified elements to a specified container")
    public ResponseEntity<List<ElementResponse>> cloneElements(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Parameter(description="Copy element requests") List<CloneElementRequest> requests) {
        log.info("Request to clone element with id: {}", (Object)chainId);
        ArrayList<ElementResponse> response = new ArrayList<ElementResponse>(requests.size());
        for (CloneElementRequest request : requests) {
            ChainElement element = this.transferableElementService.clone(request.getId(), request.getParent());
            response.add(this.elementMapper.toElementResponse(element));
        }
        return ResponseEntity.ok(response);
    }

    @PatchMapping(value={"/{elementId}"})
    @Operation(description="Change element in the chain")
    public ResponseEntity<ChainDiffResponse> patchElement(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Element id") String elementId, @RequestBody @Parameter(description="Change element request object") PatchElementRequest patchElementRequest) {
        log.info("Request for partial update for element {} in chain {}", (Object)elementId, (Object)chainId);
        ChainDiff chainDiff = new ChainDiff();
        ChainElement element = this.transferableElementService.findById(elementId);
        ContainerChainElement parentElement = element.getParent();
        String newParentId = patchElementRequest.getParentElementId();
        if (parentElement != null) {
            if (!StringUtils.equals((CharSequence)parentElement.getId(), (CharSequence)newParentId)) {
                this.transferableElementService.changeParent(element, newParentId);
            } else {
                chainDiff.merge(this.transferableElementService.updateRelativeProperties(element, patchElementRequest.getProperties()));
            }
        }
        this.elementMapper.patch(element, patchElementRequest);
        this.transferableElementService.validateElementProperties(element);
        this.transferableElementService.save(element);
        chainDiff.addUpdatedElement(element);
        for (ChainElement updatedElement : chainDiff.getUpdatedElements()) {
            this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.ELEMENT).entityId(updatedElement.getId()).entityName(updatedElement.getName()).parentType(EntityType.CHAIN).parentId(chainId).parentName(element.getChain() == null ? null : element.getChain().getName()).operation(LogOperation.UPDATE).build());
        }
        return ResponseEntity.ok((Object)this.chainDiffMapper.asResponse(chainDiff));
    }

    @PostMapping(value={"/transfer"})
    @Operation(description="Move element from one container and/or swimlane to another")
    public ResponseEntity<ChainDiffResponse> transferElement(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Parameter(description="Transfer element request object") TransferElementRequest transferElementRequest) {
        ChainDiff chainDiff = this.transferableElementService.transfer(chainId, transferElementRequest);
        ChainDiffResponse response = this.chainDiffMapper.asResponse(chainDiff);
        return ResponseEntity.ok((Object)response);
    }

    @Deprecated
    @DeleteMapping(value={"/{elementId}"})
    @Operation(description="Delete specific element from the chain")
    public ResponseEntity<ChainDiffResponse> deleteElementById(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Element id") String elementId) {
        log.info("Request to delete element with id: {} from chain {}", (Object)elementId, (Object)chainId);
        ChainDiff chainDiff = this.transferableElementService.deleteByIdAndUpdateUnsaved(elementId);
        ChainDiffResponse response = this.chainDiffMapper.asResponse(chainDiff);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={""})
    @Operation(description="Delete specified elements from the chain")
    public ResponseEntity<ChainDiffResponse> deleteElementsByIds(@PathVariable @Parameter(description="Chain id") String chainId, @RequestParam @Parameter(description="List of element ids separated by comma") List<String> elementsIds) {
        log.info("Request to delete elements with ids: {} from chain {}", elementsIds, (Object)chainId);
        ChainDiff chainDiff = this.transferableElementService.deleteAllByIdsAndUpdateUnsaved(elementsIds);
        ChainDiffResponse response = this.chainDiffMapper.asResponse(chainDiff);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/groups/{groupId}"})
    @Operation(description="Delete specified group container and ungroup element within it")
    public ResponseEntity<List<ElementResponse>> ungroup(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Container group id") String groupId) {
        log.info("Request to delete group {} in chain {}", (Object)groupId, (Object)chainId);
        List entityList = this.transferableElementService.ungroup(groupId);
        List response = this.elementMapper.toElementResponses(entityList);
        return ResponseEntity.ok((Object)response);
    }
}

