/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.FoldableEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.FolderMoveException;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainSearchRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.logging.properties.ChainLoggingPropertiesSet;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderContentFilter;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderItemRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderItemResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.ItemType;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.FolderMapper;
import org.qubership.integration.platform.designtime.catalog.service.ChainRuntimePropertiesService;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.qubership.integration.platform.designtime.catalog.service.FolderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/folders"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="folder-controller", description="Folder Controller")
public class FolderController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FolderController.class);
    private final FolderService folderService;
    private final FolderMapper folderMapper;
    private final ChainMapper chainMapper;
    private final ChainService chainService;
    private final ChainRuntimePropertiesService propertiesService;

    @Autowired
    public FolderController(FolderService folderService, FolderMapper folderMapper, ChainService chainService, ChainMapper chainMapper, ChainRuntimePropertiesService propertiesService) {
        this.folderService = folderService;
        this.folderMapper = folderMapper;
        this.chainService = chainService;
        this.chainMapper = chainMapper;
        this.propertiesService = propertiesService;
    }

    @GetMapping
    @Operation(description="Get root folder")
    public ResponseEntity<List<? extends FolderItemResponse>> findRootFolder(@RequestParam(required=false) @Parameter(description="Content filter object for a folder item request") FolderContentFilter filter, @RequestParam(required=false) @Parameter(description="Pre-opened folder (if specified, data for this folder will be fetched as well as root folder") String openedFolderId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find root folder. Content filter: {}.", (Object)filter);
        }
        List foldersInRoot = this.folderService.findAllInRoot();
        List chainsInRoot = this.chainService.findInRoot(filter);
        ArrayList response = new ArrayList(this.getListResponse((Collection)chainsInRoot, (Collection)foldersInRoot, false));
        if (filter == null && StringUtils.isNotEmpty((CharSequence)openedFolderId)) {
            this.addOpenedFolderHierarchy(openedFolderId, response);
        }
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{folderId}"})
    @Operation(description="Get specific folder")
    public ResponseEntity<FolderResponse> findById(@PathVariable @Parameter(description="Folder id") String folderId, @RequestParam(required=false) @Parameter(description="Content filter object for a folder item request") FolderContentFilter filter) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find folder by id: {}", (Object)folderId);
        }
        Folder folder = this.folderService.findById(folderId);
        FolderResponse folderResponse = this.folderMapper.asResponse(folder);
        Map navigationPath = this.folderService.provideNavigationPath(folderId);
        folderResponse.setNavigationPath(navigationPath);
        Set chainIds = this.chainService.findChainsInFolder(folderId, filter).stream().map(AbstractEntity::getId).collect(Collectors.toSet());
        List items = folderResponse.getItems().stream().filter(item -> item.getItemType().equals((Object)ItemType.FOLDER) || chainIds.contains(item.getId())).collect(Collectors.toList());
        folderResponse.setItems(items);
        this.addRuntimeProperties(items);
        return ResponseEntity.ok((Object)folderResponse);
    }

    @GetMapping(value={"/{folderId}/chains"})
    @Operation(description="Get nested chains from specified folder")
    public ResponseEntity<List<ChainResponse>> findNestedChains(@PathVariable @Parameter(description="Folder id") String folderId, @RequestParam(required=false) @Parameter(description="Content filter object for a folder item request") FolderContentFilter filter) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find nested chains by folder id: {}. Content filter: {}.", (Object)folderId, (Object)filter);
        }
        List chains = this.folderService.findNestedChains(folderId, filter);
        return ResponseEntity.ok((Object)this.chainMapper.asChainResponseLight(chains));
    }

    @GetMapping(value={"/{folderId}/elements"})
    @Operation(description="Get nested chains and folders from specified folder")
    public ResponseEntity<List<? extends FolderItemResponse>> findNestedElements(@PathVariable @Parameter(description="Folder id") String folderId, @RequestParam(required=false) @Parameter(description="Content filter object for a folder item request") FolderContentFilter filter) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find nested elements by folder id: {}. Content filter: {}.", (Object)folderId, (Object)filter);
        }
        List chains = this.folderService.findNestedChains(folderId, null);
        List folders = this.folderService.findNestedFolders(folderId);
        folders.add(this.folderService.findById(folderId));
        ArrayList response = new ArrayList(this.getListResponse((Collection)chains, (Collection)folders, true));
        return ResponseEntity.ok(response);
    }

    @PostMapping
    @Operation(description="Create a new folder")
    public ResponseEntity<FolderResponse> create(@RequestBody @Parameter(description="Folder creation request object") FolderItemRequest request) {
        log.info("Request to create new folder");
        String parentFolderId = request.getParentId();
        Folder folder = this.folderMapper.asEntity(request);
        folder = this.folderService.save(folder, parentFolderId);
        FolderResponse response = this.folderMapper.asResponse(folder);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/search"}, produces={"application/json"})
    @Operation(description="Search from root folder with chains")
    public ResponseEntity<List<? extends FolderItemResponse>> searchRootFolderWithChains(@RequestBody @Parameter(description="Folder search request object") ChainSearchRequestDTO chainSearchRequestDTO) {
        List foundChains = this.chainService.searchChains(chainSearchRequestDTO);
        List foundFolders = this.folderService.searchFolders(chainSearchRequestDTO);
        List chainsInSubfolders = this.chainService.findAllChainsInFolders(foundFolders.stream().map(AbstractEntity::getId).toList());
        TreeSet<Chain> chains = new TreeSet<Chain>(Comparator.comparing(AbstractEntity::getId));
        chains.addAll(foundChains);
        chains.addAll(chainsInSubfolders);
        List entities = Stream.concat(chains.stream(), foundFolders.stream()).toList();
        List relatedFolders = this.folderService.getFoldersHierarchically(entities);
        TreeSet<Folder> folders = new TreeSet<Folder>(Comparator.comparing(AbstractEntity::getId));
        folders.addAll(relatedFolders);
        folders.addAll(foundFolders);
        this.prepareSearchFilterResult(chains, folders);
        List response = this.getListResponse(chains, folders, true);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/filter"}, produces={"application/json"})
    @Operation(description="Filter from root folder with chains")
    public ResponseEntity<List<? extends FolderItemResponse>> filterRootFolderWithChains(@RequestBody @Parameter(description="Folder filter request object") List<FilterRequestDTO> filterRequestDTOList) {
        List chains = this.chainService.findByFilterRequest(filterRequestDTOList);
        List relatedFolders = this.folderService.getFoldersHierarchically(chains);
        this.prepareSearchFilterResult((Collection)chains, (Collection)relatedFolders);
        List response = this.getListResponse((Collection)chains, (Collection)relatedFolders, true);
        return ResponseEntity.ok((Object)response);
    }

    private void prepareSearchFilterResult(Collection<Chain> chains, Collection<Folder> folders) {
        Map folderMap = folders.stream().collect(Collectors.toMap(AbstractEntity::getId, Function.identity()));
        Stream.concat(folders.stream(), chains.stream()).forEach(entity -> {
            if (entity.getParentFolder() != null) {
                log.info("Find entity with parent folder: {}", (Object)entity.getName());
                Folder parentFolder = (Folder)folderMap.get(entity.getParentFolder().getId());
                if (entity instanceof Chain) {
                    Chain chain = (Chain)entity;
                    parentFolder.getChainList().add(chain);
                }
                if (entity instanceof Folder) {
                    Folder folder = (Folder)entity;
                    parentFolder.getFolderList().add(folder);
                }
            }
        });
    }

    @PutMapping(value={"/{folderId}"})
    @Operation(description="Update specified folder")
    public ResponseEntity<FolderResponse> update(@PathVariable @Parameter(description="Folder id") String folderId, @RequestBody @Parameter(description="Folder modification request object") FolderItemRequest request) {
        log.info("Request to update folder with id: {}", (Object)folderId);
        String parentFolderId = request.getParentId();
        Folder folder = this.folderMapper.asEntity(request);
        folder = this.folderService.update(folder, folderId, parentFolderId);
        FolderResponse response = this.folderMapper.asResponse(folder);
        Map navigationPath = this.folderService.provideNavigationPath(folderId);
        response.setNavigationPath(navigationPath);
        this.addRuntimePropertiesToChild(response);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{folderId}"})
    @Operation(description="Delete specified folder")
    public ResponseEntity<Void> deleteByIdIn(@PathVariable(value="folderId") @Parameter(description="Folder id") String id) {
        log.info("Request to delete folder with id: {}", (Object)id);
        this.folderService.deleteById(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @PostMapping(value={"/{folderId}/move"})
    @Operation(description="Move specified folder (change parent folder)")
    public ResponseEntity<FolderResponse> move(@PathVariable @Parameter(description="Folder id") String folderId, @RequestParam(required=false, defaultValue="#{null}") @Parameter(description="Target parent folder id") String targetFolderId) throws FolderMoveException {
        log.info("Request to move folder with id: {}, target folder id: {}", (Object)folderId, (Object)targetFolderId);
        Folder folderCopy = this.folderService.move(folderId, targetFolderId);
        FolderResponse response = this.folderMapper.asResponse(folderCopy);
        this.addRuntimePropertiesToChild(response);
        return ResponseEntity.ok((Object)response);
    }

    private void addRuntimePropertiesToChild(FolderResponse response) {
        this.addRuntimeProperties(response.getItems());
    }

    private void addRuntimeProperties(List<? extends FolderItemResponse> response) {
        response.forEach(item -> {
            if (item.getItemType() == ItemType.CHAIN) {
                ChainLoggingPropertiesSet props = this.propertiesService.getRuntimeProperties(item.getId());
                item.setChainRuntimeProperties(props);
            }
        });
    }

    private List<? extends FolderItemResponse> getListResponse(Collection<Chain> chainSearchResult, Collection<Folder> relatedFolders, boolean includeItems) {
        List responseList = includeItems ? this.folderMapper.asSearchItemResponse(relatedFolders) : this.folderMapper.asFolderItemResponse(relatedFolders);
        responseList.forEach(response -> response.setItemType(ItemType.FOLDER));
        List chainsResponse = this.chainMapper.asFolderItemResponse(chainSearchResult);
        chainsResponse.forEach(response -> response.setItemType(ItemType.CHAIN));
        ArrayList result = new ArrayList(responseList.size() + chainsResponse.size());
        result.addAll(responseList);
        result.addAll(chainsResponse);
        this.addRuntimeProperties(result);
        return result;
    }

    private void addOpenedFolderHierarchy(String openedFolderId, List<FolderItemResponse> response) {
        List openedFolderRelatedFolders = this.folderService.findAllFoldersToRootParentFolder(openedFolderId);
        List openedFolderRelatedChains = this.chainService.findAllChainsToRootParentFolder(openedFolderId);
        Map folderMap = openedFolderRelatedFolders.stream().collect(Collectors.toMap(AbstractEntity::getId, Function.identity()));
        Map chainMap = openedFolderRelatedChains.stream().collect(Collectors.toMap(AbstractEntity::getId, Function.identity()));
        for (Folder folder : openedFolderRelatedFolders) {
            if (folder.getParentFolder() == null) {
                response.removeIf(item -> item.getId().equals(folder.getId()));
            }
            if (!this.hasExtraChild(folder.getFolderList(), folderMap, chainMap) && !this.hasExtraChild(folder.getChainList(), folderMap, chainMap)) continue;
            folder.setFolderList(null);
            folder.setChainList(null);
        }
        response.addAll(this.getListResponse((Collection)openedFolderRelatedChains, (Collection)openedFolderRelatedFolders, true));
    }

    private boolean hasExtraChild(List<? extends FoldableEntity> entities, Map<String, Folder> folderMap, Map<String, Chain> chainMap) {
        for (FoldableEntity foldableEntity : entities) {
            if ((!(foldableEntity instanceof Folder) || folderMap.containsKey(foldableEntity.getId())) && (!(foldableEntity instanceof Chain) || chainMap.containsKey(foldableEntity.getId()))) continue;
            return true;
        }
        return false;
    }
}

