/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.qubership.integration.platform.catalog.mapping.exportimport.instructions.GeneralInstructionsMapper;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.GeneralImportInstructionsDTO;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionDTO;
import org.qubership.integration.platform.catalog.persistence.configs.entity.instructions.ImportInstruction;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.exportimport.instructions.DeleteInstructionsRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.exportimport.instructions.ImportInstructionRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.exportimport.instructions.ImportInstructionsSearchRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ImportInstructionRequestMapper;
import org.qubership.integration.platform.designtime.catalog.service.exportimport.instructions.ImportInstructionsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/import-instructions"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="import-instructions-controller", description="Import Instructions Controller")
public class ImportInstructionsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportInstructionsController.class);
    private final ImportInstructionRequestMapper importInstructionRequestMapper;
    private final GeneralInstructionsMapper generalInstructionsMapper;
    private final ImportInstructionsService importInstructionsService;

    public ImportInstructionsController(ImportInstructionRequestMapper importInstructionRequestMapper, GeneralInstructionsMapper generalInstructionsMapper, ImportInstructionsService importInstructionsService) {
        this.importInstructionRequestMapper = importInstructionRequestMapper;
        this.generalInstructionsMapper = generalInstructionsMapper;
        this.importInstructionsService = importInstructionsService;
    }

    @GetMapping
    @Operation(description="Get all import instructions")
    public ResponseEntity<GeneralImportInstructionsDTO> getImportInstructions() {
        if (log.isDebugEnabled()) {
            log.debug("Request to get all import instructions");
        }
        List importInstructions = this.importInstructionsService.getImportInstructions();
        GeneralImportInstructionsDTO generalImportInstructions = this.generalInstructionsMapper.asDTO(importInstructions);
        return ResponseEntity.ok((Object)generalImportInstructions);
    }

    @PostMapping(value={"/search"}, produces={"application/json"})
    @Operation(description="Search for import instructions")
    public ResponseEntity<GeneralImportInstructionsDTO> searchImportInstructions(@RequestBody @Parameter(description="Import instructions search request object") ImportInstructionsSearchRequestDTO importInstructionsSearchRequestDTO) {
        GeneralImportInstructionsDTO instructionsDTO = this.generalInstructionsMapper.asDTO(this.importInstructionsService.searchImportInstructions(importInstructionsSearchRequestDTO.getSearchCondition()));
        return ResponseEntity.ok((Object)instructionsDTO);
    }

    @PostMapping(value={"/filter"}, produces={"application/json"})
    @Operation(description="Filter import instructions")
    public ResponseEntity<GeneralImportInstructionsDTO> filterImportInstructions(@RequestBody @Parameter(description="Import instructions filter request object") List<FilterRequestDTO> filterRequestDTOS) {
        GeneralImportInstructionsDTO instructionsDTO = this.generalInstructionsMapper.asDTO(this.importInstructionsService.getImportInstructions(filterRequestDTOS));
        return ResponseEntity.ok((Object)instructionsDTO);
    }

    @PostMapping(consumes={"application/json"})
    @Operation(description="Create new import instruction")
    public ResponseEntity<ImportInstructionDTO> addImportInstruction(@RequestBody @Valid @Parameter(description="Create import instructions request object") ImportInstructionRequest importInstructionRequest) {
        if (log.isDebugEnabled()) {
            log.debug("Request to add new import instruction: {}", (Object)importInstructionRequest);
        }
        ImportInstruction importInstruction = this.importInstructionRequestMapper.toEntity(importInstructionRequest);
        importInstruction = this.importInstructionsService.addImportInstruction(importInstruction);
        return ResponseEntity.ok((Object)this.generalInstructionsMapper.entityToDTO(importInstruction));
    }

    @PatchMapping(consumes={"application/json"})
    @Operation(description="Update existing import instruction")
    public ResponseEntity<ImportInstructionDTO> updateImportInstructionsConfig(@RequestBody @Valid @Parameter(description="Update import instruction request object") ImportInstructionRequest importInstructionRequest) {
        if (log.isDebugEnabled()) {
            log.debug("Request to update existing import instruction: {}", (Object)importInstructionRequest);
        }
        ImportInstruction importInstruction = this.importInstructionRequestMapper.toEntity(importInstructionRequest);
        importInstruction = this.importInstructionsService.updateImportInstruction(importInstruction);
        return ResponseEntity.ok((Object)this.generalInstructionsMapper.entityToDTO(importInstruction));
    }

    @DeleteMapping(consumes={"application/json"})
    @Operation(description="Delete import instructions")
    public ResponseEntity<Void> deleteImportInstructions(@RequestBody @Parameter(description="Delete import instructions request object") DeleteInstructionsRequest deleteInstructionsRequest) {
        if (log.isDebugEnabled()) {
            log.debug("Request to delete import instructions: {}", (Object)deleteInstructionsRequest);
        }
        this.importInstructionsService.deleteImportInstructionsById(deleteInstructionsRequest);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }
}

