/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.qubership.integration.platform.catalog.model.deployment.properties.DeploymentRuntimeProperties;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.logging.properties.ChainLoggingPropertiesSet;
import org.qubership.integration.platform.designtime.catalog.service.ChainRuntimePropertiesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/chains"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="logging-properties-controller", description="Logging Properties Controller")
public class LoggingPropertiesController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingPropertiesController.class);
    private final ChainRuntimePropertiesService propertiesService;

    @Autowired
    public LoggingPropertiesController(ChainRuntimePropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    @GetMapping(value={"/{chainId}/properties/logging"})
    @Operation(description="Get logging deployment properties for specified chain")
    public ResponseEntity<ChainLoggingPropertiesSet> findByChainId(@PathVariable @Parameter(description="Chain id") String chainId) {
        ChainLoggingPropertiesSet runtimeProperties = this.propertiesService.getRuntimeProperties(chainId);
        return ResponseEntity.ok((Object)runtimeProperties);
    }

    @PostMapping(value={"/{chainId}/properties/logging"})
    @Operation(description="Save logging deployment properties for specified chain")
    public ResponseEntity<Void> saveProperties(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Parameter(description="Chain logging deployment properties") DeploymentRuntimeProperties request) {
        this.propertiesService.saveRuntimeProperties(chainId, request);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{chainId}/properties/logging"})
    @Operation(description="Remove custom logging properties for chain (make default)")
    public ResponseEntity<Void> deleteProperties(@PathVariable @Parameter(description="Chain id") String chainId) {
        this.propertiesService.deleteCustomRuntimeProperties(chainId);
        return ResponseEntity.noContent().build();
    }
}

