/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.controller;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.OperationDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.OperationInfoDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.OperationMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.OperationSchemasMapper;
import org.qubership.integration.platform.designtime.catalog.service.OperationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/operations"})
@Tag(name="operation-controller", description="Operation Controller")
public class OperationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperationController.class);
    private final OperationService operationService;
    private final OperationMapper operationMapper;
    private final OperationSchemasMapper operationSchemasMapper;

    @Autowired
    public OperationController(OperationService operationService, OperationMapper operationMapper, OperationSchemasMapper operationSchemasMapper) {
        this.operationService = operationService;
        this.operationMapper = operationMapper;
        this.operationSchemasMapper = operationSchemasMapper;
    }

    @GetMapping(value={"/{operationId}"}, produces={"application/json"})
    @io.swagger.v3.oas.annotations.Operation(description="Get specific operation")
    public OperationDTO getOperation(@PathVariable @Parameter(description="Operation id") String operationId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get operation {}", (Object)operationId);
        }
        Operation operation = this.operationService.getOperation(operationId);
        return this.operationMapper.toOperationDTO(operation);
    }

    @GetMapping(produces={"application/json"})
    @io.swagger.v3.oas.annotations.Operation(description="Get list of operations from specification")
    public ResponseEntity<List<OperationDTO>> getOperationsByModel(@RequestParam @Parameter(description="Specification id") String modelId, @RequestParam(required=false, defaultValue="0") @Parameter(description="Which entity order number should we start from") int offset, @RequestParam(required=false, defaultValue="20") @Parameter(description="Amount of entities received at a time") int count, @RequestParam(required=false, defaultValue="") @Parameter(description="Search value") String searchFilter, @RequestParam(required=false, defaultValue="path, method, name") @Parameter(description="Column names which will be used to sort response, separated by comma") List<String> sortColumns) {
        List operations;
        if (log.isDebugEnabled()) {
            log.debug("Request to get operation by model {}", (Object)modelId);
        }
        try {
            operations = this.operationService.getOperationsByModel(modelId, offset, count, searchFilter, sortColumns);
        }
        catch (InvalidDataAccessResourceUsageException e) {
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok((Object)this.operationMapper.toOperationDTOs(operations));
    }

    @GetMapping(value={"/{operationId}/schemas"}, produces={"application/json"})
    @io.swagger.v3.oas.annotations.Operation(description="Get specific operation with schemas")
    public Object getOperationWithSchemas(@PathVariable @Parameter(description="Operation id") String operationId, @RequestParam(required=false, defaultValue="light") @Parameter(description="If \"light\" was passed - response will be without part of request and response schemas. Otherwise all data will be included in response.") String mode) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get operation {} with schemas", (Object)operationId);
        }
        if (mode.equals("light")) {
            Operation operation = this.operationService.getOperationLight(operationId);
            return this.operationSchemasMapper.toOperationSchemasDTO(operation);
        }
        Operation operation = this.operationService.getOperation(operationId);
        return this.operationSchemasMapper.toOperationSchemasDTO(operation);
    }

    @GetMapping(value={"/{operationId}/info"}, produces={"application/json"})
    @io.swagger.v3.oas.annotations.Operation(description="Get specific operation info")
    public ResponseEntity<OperationInfoDTO> getInfo(@PathVariable @Parameter(description="Operation id") String operationId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get operation {} info", (Object)operationId);
        }
        return ResponseEntity.ok((Object)this.operationMapper.toOperationInfoDTO(this.operationService.getOperation(operationId)));
    }

    @GetMapping(value={"/{operationId}/specification"}, produces={"application/json"})
    @io.swagger.v3.oas.annotations.Operation(description="Get specification part related to specified operation")
    public Object getSpecification(@PathVariable @Parameter(description="Operation id") String operationId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get operation {} specification", (Object)operationId);
        }
        return this.operationService.getSpecification(operationId);
    }

    @GetMapping(value={"/{operationId}/schemas/request"}, produces={"application/json"})
    @io.swagger.v3.oas.annotations.Operation(description="Get request schema from specification related to specified operation")
    public JsonNode getOperationRequestSchema(@PathVariable @Parameter(description="Operation id") String operationId, @RequestParam(defaultValue="application/json") @Parameter(description="Content-type for schema") String contentType) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get operation {} request schema", (Object)operationId);
        }
        return this.operationService.getRequestSchema(operationId, contentType);
    }

    @GetMapping(value={"/{operationId}/schemas/response"}, produces={"application/json"})
    @io.swagger.v3.oas.annotations.Operation(description="Get response schema from specification related to specified operation")
    public JsonNode getOperationResponseSchema(@PathVariable @Parameter(description="Operation id") String operationId, @RequestParam(defaultValue="application/json") @Parameter(description="Content-type for schema") String contentType, @RequestParam(required=false, defaultValue="200") @Parameter(description="Response code for schema") String responseCode) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get operation {} response schema", (Object)operationId);
        }
        return this.operationService.getResponseSchema(operationId, contentType, responseCode);
    }
}

