/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.dto.exportimport.instructions;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.qubership.integration.platform.catalog.validation.constraint.ChainNotOverrideItself;
import org.qubership.integration.platform.catalog.validation.constraint.NotStartOrEndWithSpace;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.exportimport.instructions.ImportInstructionRequest;

@Schema(description="Import instruction create/update object")
@ChainNotOverrideItself
public class ImportInstructionRequest {
    @Schema(description="Import instruction id")
    @NotStartOrEndWithSpace(message="must not be empty and must not start or end with a space")
    private @NotStartOrEndWithSpace(message="must not be empty and must not start or end with a space") String id;
    @Schema(description="The type of entity to which instruction will apply", allowableValues={"CHAIN", "SERVICE"})
    @NotNull(message="must not be null")
    @Pattern(regexp="CHAIN|SERVICE", message="must be CHAIN or SERVICE")
    private @NotNull(message="must not be null") @Pattern(regexp="CHAIN|SERVICE", message="must be CHAIN or SERVICE") String entityType;
    @Schema(description="Import instruction action", allowableValues={"IGNORE", "OVERRIDE"})
    @NotNull(message="must not be null")
    @Pattern(regexp="IGNORE|OVERRIDE", message="must be IGNORE or OVERRIDE")
    private @NotNull(message="must not be null") @Pattern(regexp="IGNORE|OVERRIDE", message="must be IGNORE or OVERRIDE") String action;
    @Schema(description="Id of chain to be overridden")
    @NotStartOrEndWithSpace(optional=true, message="must not start or end with a space")
    private @NotStartOrEndWithSpace(optional=true, message="must not start or end with a space") String overriddenBy;

    @Generated
    protected ImportInstructionRequest(ImportInstructionRequestBuilder<?, ?> b) {
        this.id = b.id;
        this.entityType = b.entityType;
        this.action = b.action;
        this.overriddenBy = b.overriddenBy;
    }

    @Generated
    public static ImportInstructionRequestBuilder<?, ?> builder() {
        return new ImportInstructionRequestBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEntityType() {
        return this.entityType;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getOverriddenBy() {
        return this.overriddenBy;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public void setOverriddenBy(String overriddenBy) {
        this.overriddenBy = overriddenBy;
    }

    @Generated
    public ImportInstructionRequest() {
    }

    @Generated
    public String toString() {
        return "ImportInstructionRequest(id=" + this.getId() + ", entityType=" + this.getEntityType() + ", action=" + this.getAction() + ", overriddenBy=" + this.getOverriddenBy() + ")";
    }
}

