/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.model.dto.BaseResponse;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.ChainLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.catalog.util.StringTrimmer;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainLabelDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainsBySpecificationGroup;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderItemResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainLabelsMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.DependencyMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.DeploymentMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ElementMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChainMapperImpl
implements ChainMapper {
    @Autowired
    private DependencyMapper dependencyMapper;
    @Autowired
    private ElementMapper elementMapper;
    @Autowired
    private DeploymentMapper deploymentMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private StringTrimmer stringTrimmer;
    @Autowired
    private ChainLabelsMapper chainLabelsMapper;

    public ChainDTO asDTO(Chain chain) {
        if (chain == null) {
            return null;
        }
        ChainDTO.ChainDTOBuilder chainDTO = ChainDTO.builder();
        chainDTO.currentSnapshot(this.snapshotToBaseResponse(chain.getCurrentSnapshot()));
        chainDTO.dependencies(this.dependencyMapper.extractDependencies(chain.getElements()));
        chainDTO.elements(this.elementMapper.toElementResponses(chain));
        chainDTO.parentId(this.stringTrimmer.trimString(this.chainParentFolderId(chain)));
        chainDTO.defaultSwimlaneId(this.stringTrimmer.trimString(this.chainDefaultSwimlaneId(chain)));
        chainDTO.reuseSwimlaneId(this.stringTrimmer.trimString(this.chainReuseSwimlaneId(chain)));
        chainDTO.overriddenByChainName(this.stringTrimmer.trimString(this.chainOverriddenByChainName(chain)));
        chainDTO.overridesChainName(this.stringTrimmer.trimString(this.chainOverridesChainName(chain)));
        chainDTO.id(this.stringTrimmer.trimString(chain.getId()));
        chainDTO.name(this.stringTrimmer.trimString(chain.getName()));
        chainDTO.description(this.stringTrimmer.trimString(chain.getDescription()));
        chainDTO.createdWhen(MapperUtils.fromTimestamp((Timestamp)chain.getCreatedWhen()));
        chainDTO.createdBy(this.userMapper.asDTO(chain.getCreatedBy()));
        chainDTO.modifiedWhen(MapperUtils.fromTimestamp((Timestamp)chain.getModifiedWhen()));
        chainDTO.modifiedBy(this.userMapper.asDTO(chain.getModifiedBy()));
        chainDTO.deployments(this.deploymentMapper.asResponses(chain.getDeployments()));
        chainDTO.labels(this.chainLabelSetToChainLabelDTOList(chain.getLabels()));
        chainDTO.unsavedChanges(chain.isUnsavedChanges());
        chainDTO.businessDescription(this.stringTrimmer.trimString(chain.getBusinessDescription()));
        chainDTO.assumptions(this.stringTrimmer.trimString(chain.getAssumptions()));
        chainDTO.outOfScope(this.stringTrimmer.trimString(chain.getOutOfScope()));
        chainDTO.overriddenByChainId(this.stringTrimmer.trimString(chain.getOverriddenByChainId()));
        chainDTO.overridesChainId(this.stringTrimmer.trimString(chain.getOverridesChainId()));
        return chainDTO.build();
    }

    public List<ChainDTO> asDTO(List<Chain> chains) {
        if (chains == null) {
            return null;
        }
        ArrayList<ChainDTO> list = new ArrayList<ChainDTO>(chains.size());
        for (Chain chain : chains) {
            list.add(this.asDTO(chain));
        }
        return list;
    }

    public List<FolderItemResponse> asFolderItemResponse(Collection<Chain> chains) {
        if (chains == null) {
            return null;
        }
        ArrayList<FolderItemResponse> list = new ArrayList<FolderItemResponse>(chains.size());
        for (Chain chain : chains) {
            list.add(this.asFolderItemResponse(chain));
        }
        return list;
    }

    public FolderItemResponse asFolderItemResponse(Chain chain) {
        if (chain == null) {
            return null;
        }
        FolderItemResponse.FolderItemResponseBuilder folderItemResponse = FolderItemResponse.builder();
        folderItemResponse.parentId(this.stringTrimmer.trimString(this.chainParentFolderId(chain)));
        folderItemResponse.overriddenByChainName(this.stringTrimmer.trimString(this.chainOverriddenByChainName(chain)));
        folderItemResponse.overridesChainName(this.stringTrimmer.trimString(this.chainOverridesChainName(chain)));
        folderItemResponse.id(this.stringTrimmer.trimString(chain.getId()));
        folderItemResponse.name(this.stringTrimmer.trimString(chain.getName()));
        folderItemResponse.description(this.stringTrimmer.trimString(chain.getDescription()));
        folderItemResponse.createdWhen(MapperUtils.fromTimestamp((Timestamp)chain.getCreatedWhen()));
        folderItemResponse.createdBy(this.userMapper.asDTO(chain.getCreatedBy()));
        folderItemResponse.modifiedWhen(MapperUtils.fromTimestamp((Timestamp)chain.getModifiedWhen()));
        folderItemResponse.modifiedBy(this.userMapper.asDTO(chain.getModifiedBy()));
        folderItemResponse.labels(this.chainLabelSetToChainLabelDTOList(chain.getLabels()));
        folderItemResponse.deployments(this.deploymentMapper.asResponses(chain.getDeployments()));
        folderItemResponse.businessDescription(this.stringTrimmer.trimString(chain.getBusinessDescription()));
        folderItemResponse.assumptions(this.stringTrimmer.trimString(chain.getAssumptions()));
        folderItemResponse.outOfScope(this.stringTrimmer.trimString(chain.getOutOfScope()));
        folderItemResponse.overriddenByChainId(this.stringTrimmer.trimString(chain.getOverriddenByChainId()));
        folderItemResponse.overridesChainId(this.stringTrimmer.trimString(chain.getOverridesChainId()));
        return folderItemResponse.build();
    }

    public ChainResponse asChainResponseLight(Chain chain) {
        if (chain == null) {
            return null;
        }
        ChainResponse.ChainResponseBuilder chainResponse = ChainResponse.builder();
        chainResponse.parentId(this.stringTrimmer.trimString(this.chainParentFolderId(chain)));
        chainResponse.defaultSwimlaneId(this.stringTrimmer.trimString(this.chainDefaultSwimlaneId(chain)));
        chainResponse.reuseSwimlaneId(this.stringTrimmer.trimString(this.chainReuseSwimlaneId(chain)));
        chainResponse.id(this.stringTrimmer.trimString(chain.getId()));
        chainResponse.name(this.stringTrimmer.trimString(chain.getName()));
        chainResponse.description(this.stringTrimmer.trimString(chain.getDescription()));
        chainResponse.createdWhen(MapperUtils.fromTimestamp((Timestamp)chain.getCreatedWhen()));
        chainResponse.createdBy(this.userMapper.asDTO(chain.getCreatedBy()));
        chainResponse.modifiedWhen(MapperUtils.fromTimestamp((Timestamp)chain.getModifiedWhen()));
        chainResponse.modifiedBy(this.userMapper.asDTO(chain.getModifiedBy()));
        chainResponse.labels(this.chainLabelSetToChainLabelDTOList(chain.getLabels()));
        return chainResponse.build();
    }

    public List<ChainResponse> asChainResponseLight(List<Chain> response) {
        if (response == null) {
            return null;
        }
        ArrayList<ChainResponse> list = new ArrayList<ChainResponse>(response.size());
        for (Chain chain : response) {
            list.add(this.asChainResponseLight(chain));
        }
        return list;
    }

    public ChainsBySpecificationGroup asChainsBySpecificationGroup(String specificationGroupId, List<Chain> chains) {
        if (specificationGroupId == null && chains == null) {
            return null;
        }
        ChainsBySpecificationGroup.ChainsBySpecificationGroupBuilder chainsBySpecificationGroup = ChainsBySpecificationGroup.builder();
        chainsBySpecificationGroup.specificationGroupId(this.stringTrimmer.trimString(specificationGroupId));
        chainsBySpecificationGroup.chains(this.asChainResponseLight(chains));
        return chainsBySpecificationGroup.build();
    }

    public Chain mapRequest(ChainRequest request) {
        if (request == null) {
            return null;
        }
        Chain.ChainBuilder chain = Chain.builder();
        chain.name(this.stringTrimmer.trimString(request.getName()));
        chain.description(this.stringTrimmer.trimString(request.getDescription()));
        chain.labels(this.chainLabelDTOListToChainLabelSet(request.getLabels()));
        chain.businessDescription(this.stringTrimmer.trimString(request.getBusinessDescription()));
        chain.assumptions(this.stringTrimmer.trimString(request.getAssumptions()));
        chain.outOfScope(this.stringTrimmer.trimString(request.getOutOfScope()));
        return chain.build();
    }

    public void mergeWithoutLabels(Chain chain, ChainRequest chainRequest) {
        if (chainRequest == null) {
            return;
        }
        if (chainRequest.getName() != null) {
            chain.setName(this.stringTrimmer.trimString(chainRequest.getName()));
        }
        if (chainRequest.getDescription() != null) {
            chain.setDescription(this.stringTrimmer.trimString(chainRequest.getDescription()));
        }
        if (chainRequest.getBusinessDescription() != null) {
            chain.setBusinessDescription(this.stringTrimmer.trimString(chainRequest.getBusinessDescription()));
        }
        if (chainRequest.getAssumptions() != null) {
            chain.setAssumptions(this.stringTrimmer.trimString(chainRequest.getAssumptions()));
        }
        if (chainRequest.getOutOfScope() != null) {
            chain.setOutOfScope(this.stringTrimmer.trimString(chainRequest.getOutOfScope()));
        }
    }

    protected BaseResponse snapshotToBaseResponse(Snapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        BaseResponse.BaseResponseBuilder baseResponse = BaseResponse.builder();
        baseResponse.id(this.stringTrimmer.trimString(snapshot.getId()));
        baseResponse.name(this.stringTrimmer.trimString(snapshot.getName()));
        baseResponse.description(this.stringTrimmer.trimString(snapshot.getDescription()));
        baseResponse.createdWhen(MapperUtils.fromTimestamp((Timestamp)snapshot.getCreatedWhen()));
        baseResponse.createdBy(this.userMapper.asDTO(snapshot.getCreatedBy()));
        baseResponse.modifiedWhen(MapperUtils.fromTimestamp((Timestamp)snapshot.getModifiedWhen()));
        baseResponse.modifiedBy(this.userMapper.asDTO(snapshot.getModifiedBy()));
        return baseResponse.build();
    }

    private String chainParentFolderId(Chain chain) {
        if (chain == null) {
            return null;
        }
        Folder parentFolder = chain.getParentFolder();
        if (parentFolder == null) {
            return null;
        }
        String id = parentFolder.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String chainDefaultSwimlaneId(Chain chain) {
        if (chain == null) {
            return null;
        }
        SwimlaneChainElement defaultSwimlane = chain.getDefaultSwimlane();
        if (defaultSwimlane == null) {
            return null;
        }
        String id = defaultSwimlane.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String chainReuseSwimlaneId(Chain chain) {
        if (chain == null) {
            return null;
        }
        SwimlaneChainElement reuseSwimlane = chain.getReuseSwimlane();
        if (reuseSwimlane == null) {
            return null;
        }
        String id = reuseSwimlane.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String chainOverriddenByChainName(Chain chain) {
        if (chain == null) {
            return null;
        }
        Chain overriddenByChain = chain.getOverriddenByChain();
        if (overriddenByChain == null) {
            return null;
        }
        String name = overriddenByChain.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private String chainOverridesChainName(Chain chain) {
        if (chain == null) {
            return null;
        }
        Chain overridesChain = chain.getOverridesChain();
        if (overridesChain == null) {
            return null;
        }
        String name = overridesChain.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    protected List<ChainLabelDTO> chainLabelSetToChainLabelDTOList(Set<ChainLabel> set) {
        if (set == null) {
            return null;
        }
        ArrayList<ChainLabelDTO> list = new ArrayList<ChainLabelDTO>(set.size());
        for (ChainLabel chainLabel : set) {
            list.add(this.chainLabelsMapper.asDTO(chainLabel));
        }
        return list;
    }

    protected ChainLabel chainLabelDTOToChainLabel(ChainLabelDTO chainLabelDTO) {
        if (chainLabelDTO == null) {
            return null;
        }
        ChainLabel.ChainLabelBuilder chainLabel = ChainLabel.builder();
        chainLabel.name(this.stringTrimmer.trimString(chainLabelDTO.getName()));
        if (chainLabelDTO.getTechnical() != null) {
            chainLabel.technical(chainLabelDTO.getTechnical().booleanValue());
        }
        return chainLabel.build();
    }

    protected Set<ChainLabel> chainLabelDTOListToChainLabelSet(List<ChainLabelDTO> list) {
        if (list == null) {
            return null;
        }
        LinkedHashSet<ChainLabel> set = new LinkedHashSet<ChainLabel>(Math.max((int)((float)list.size() / 0.75f) + 1, 16));
        for (ChainLabelDTO chainLabelDTO : list) {
            set.add(this.chainLabelDTOToChainLabel(chainLabelDTO));
        }
        return set;
    }
}

