/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.catalog.model.dto.deployment.DeploymentResponse;
import org.qubership.integration.platform.catalog.model.dto.deployment.RuntimeDeploymentState;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.DeploymentMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeploymentMapperImpl
extends DeploymentMapper {
    @Autowired
    private UserMapper userMapper;

    public DeploymentResponse asResponse(Deployment deployment) {
        if (deployment == null) {
            return null;
        }
        DeploymentResponse.DeploymentResponseBuilder deploymentResponse = DeploymentResponse.builder();
        deploymentResponse.snapshotId(this.deploymentSnapshotId(deployment));
        deploymentResponse.chainId(this.deploymentChainId(deployment));
        deploymentResponse.id(deployment.getId());
        deploymentResponse.name(deployment.getName());
        deploymentResponse.domain(deployment.getDomain());
        deploymentResponse.createdWhen(MapperUtils.fromTimestamp((Timestamp)deployment.getCreatedWhen()));
        deploymentResponse.createdBy(this.userMapper.asDTO(deployment.getCreatedBy()));
        deploymentResponse.suspended(deployment.isSuspended());
        return deploymentResponse.build();
    }

    public List<DeploymentResponse> asResponses(List<Deployment> deploymentEntityEngineList) {
        if (deploymentEntityEngineList == null) {
            return null;
        }
        ArrayList<DeploymentResponse> list = new ArrayList<DeploymentResponse>(deploymentEntityEngineList.size());
        for (Deployment deployment : deploymentEntityEngineList) {
            list.add(this.asResponse(deployment));
        }
        return list;
    }

    public RuntimeDeploymentState toDTO(EngineDeployment state) {
        if (state == null) {
            return null;
        }
        RuntimeDeploymentState runtimeDeploymentState = new RuntimeDeploymentState();
        runtimeDeploymentState.setStatus(state.getStatus());
        runtimeDeploymentState.setError(state.getErrorMessage());
        runtimeDeploymentState.setSuspended(state.isSuspended());
        return runtimeDeploymentState;
    }

    private String deploymentSnapshotId(Deployment deployment) {
        if (deployment == null) {
            return null;
        }
        Snapshot snapshot = deployment.getSnapshot();
        if (snapshot == null) {
            return null;
        }
        String id = snapshot.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String deploymentChainId(Deployment deployment) {
        if (deployment == null) {
            return null;
        }
        Chain chain = deployment.getChain();
        if (chain == null) {
            return null;
        }
        String id = chain.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

