/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.discovery.DiscoveredServiceDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.discovery.DiscoveredServiceGroupDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.DiscoveryServiceMapper;
import org.springframework.stereotype.Component;

@Component
public class DiscoveryServiceMapperImpl
extends DiscoveryServiceMapper {
    public DiscoveredServiceDTO toDiscoveredServiceDTO(IntegrationSystem system) {
        if (system == null) {
            return null;
        }
        DiscoveredServiceDTO discoveredServiceDTO = new DiscoveredServiceDTO();
        discoveredServiceDTO.setId(system.getId());
        discoveredServiceDTO.setName(system.getName());
        discoveredServiceDTO.setInternalServiceName(system.getInternalServiceName());
        discoveredServiceDTO.setCreatedWhen(MapperUtils.fromTimestamp((Timestamp)system.getCreatedWhen()));
        this.after(system, discoveredServiceDTO);
        return discoveredServiceDTO;
    }

    public DiscoveredServiceGroupDTO toDiscoveredServiceGroupDTO(SpecificationGroup group) {
        if (group == null) {
            return null;
        }
        DiscoveredServiceGroupDTO discoveredServiceGroupDTO = new DiscoveredServiceGroupDTO();
        discoveredServiceGroupDTO.setId(group.getId());
        discoveredServiceGroupDTO.setName(group.getName());
        discoveredServiceGroupDTO.setSynchronization(group.isSynchronization());
        discoveredServiceGroupDTO.setCreatedWhen(MapperUtils.fromTimestamp((Timestamp)group.getCreatedWhen()));
        this.afterGroup(group, discoveredServiceGroupDTO);
        return discoveredServiceGroupDTO;
    }

    public List<DiscoveredServiceDTO> toDiscoveredServiceDTOs(List<IntegrationSystem> systems) {
        if (systems == null) {
            return null;
        }
        ArrayList<DiscoveredServiceDTO> list = new ArrayList<DiscoveredServiceDTO>(systems.size());
        for (IntegrationSystem integrationSystem : systems) {
            list.add(this.toDiscoveredServiceDTO(integrationSystem));
        }
        return list;
    }

    public List<DiscoveredServiceGroupDTO> toDiscoveredServiceGroupDTOs(List<SpecificationGroup> groups) {
        if (groups == null) {
            return null;
        }
        ArrayList<DiscoveredServiceGroupDTO> list = new ArrayList<DiscoveredServiceGroupDTO>(groups.size());
        for (SpecificationGroup specificationGroup : groups) {
            list.add(this.toDiscoveredServiceGroupDTO(specificationGroup));
        }
        return list;
    }
}

