/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderItemRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderItemResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.ItemType;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.SearchFilterItemResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainLabelsMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainMapper;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", uses={ChainMapper.class, MapperUtils.class, UserMapper.class, ChainLabelsMapper.class})
public abstract class FolderMapper {
    @Autowired
    private ChainMapper chainMapper;

    public abstract Folder asEntity(FolderItemRequest var1);

    @Mapping(source="parentFolder", target="parentId")
    public FolderResponse asResponse(Folder folder) {
        FolderResponse folderItem = new FolderResponse();
        this.merge(folderItem, folder);
        this.buildItemList(folderItem, folder);
        return folderItem;
    }

    public List<SearchFilterItemResponse> asSearchItemResponse(Collection<Folder> folders) {
        return folders.stream().map(arg_0 -> this.asFolderSearchResponse(arg_0)).toList();
    }

    @Mapping(source="parentFolder.id", target="parentId")
    public abstract SearchFilterItemResponse asSearchItemResponse(Folder var1);

    public SearchFilterItemResponse asFolderSearchResponse(Folder entity) {
        boolean containsChains;
        SearchFilterItemResponse searchItemResponse = this.asSearchItemResponse(entity);
        boolean containsFolders = entity.getFolderList() != null;
        boolean bl = containsChains = entity.getChainList() != null;
        if (containsFolders || containsChains) {
            searchItemResponse.setItems(Stream.concat(!containsFolders ? Stream.empty() : entity.getFolderList().stream(), !containsChains ? Stream.empty() : entity.getChainList().stream()).map(foldableEntity -> foldableEntity instanceof Chain ? this.chainMapper.asFolderItemResponse((Chain)foldableEntity) : this.asFolderItemResponse((Folder)foldableEntity)).toList());
        }
        return searchItemResponse;
    }

    @IterableMapping(elementTargetType=FolderItemResponse.class)
    public abstract List<FolderItemResponse> asFolderItemResponse(Collection<Folder> var1);

    @Mapping(source="parentFolder.id", target="parentId")
    public abstract FolderItemResponse asFolderItemResponse(Folder var1);

    @Mapping(source="parentFolder.id", target="parentId")
    public abstract void merge(@MappingTarget FolderResponse var1, Folder var2);

    private void buildItemList(@MappingTarget FolderResponse responseDTO, Folder folder) {
        List folders;
        List folderItems;
        ArrayList items = new ArrayList();
        List chains = folder.getChainList();
        List chainFolderItems = this.chainMapper.asFolderItemResponse((Collection)chains);
        if (chainFolderItems != null) {
            chainFolderItems.forEach(element -> element.setItemType(ItemType.CHAIN));
            items.addAll(chainFolderItems);
        }
        if ((folderItems = this.asFolderItemResponse((Collection)(folders = folder.getFolderList()))) != null) {
            folderItems.forEach(element -> element.setItemType(ItemType.FOLDER));
            items.addAll(folderItems);
        }
        responseDTO.setItems(items);
    }

    @Generated
    public FolderMapper() {
    }
}

