/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderItemRequest;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderItemResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.SearchFilterItemResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.FolderMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FolderMapperImpl
extends FolderMapper {
    @Autowired
    private UserMapper userMapper;

    public Folder asEntity(FolderItemRequest request) {
        if (request == null) {
            return null;
        }
        Folder.FolderBuilder folder = Folder.builder();
        folder.name(request.getName());
        folder.description(request.getDescription());
        return folder.build();
    }

    public SearchFilterItemResponse asSearchItemResponse(Folder entity) {
        if (entity == null) {
            return null;
        }
        SearchFilterItemResponse.SearchFilterItemResponseBuilder searchFilterItemResponse = SearchFilterItemResponse.builder();
        searchFilterItemResponse.parentId(this.entityParentFolderId(entity));
        searchFilterItemResponse.id(entity.getId());
        searchFilterItemResponse.name(entity.getName());
        searchFilterItemResponse.description(entity.getDescription());
        searchFilterItemResponse.createdWhen(MapperUtils.fromTimestamp((Timestamp)entity.getCreatedWhen()));
        searchFilterItemResponse.createdBy(this.userMapper.asDTO(entity.getCreatedBy()));
        searchFilterItemResponse.modifiedWhen(MapperUtils.fromTimestamp((Timestamp)entity.getModifiedWhen()));
        searchFilterItemResponse.modifiedBy(this.userMapper.asDTO(entity.getModifiedBy()));
        return searchFilterItemResponse.build();
    }

    public List<FolderItemResponse> asFolderItemResponse(Collection<Folder> folder) {
        if (folder == null) {
            return null;
        }
        ArrayList<FolderItemResponse> list = new ArrayList<FolderItemResponse>(folder.size());
        for (Folder folder1 : folder) {
            list.add(this.asFolderItemResponse(folder1));
        }
        return list;
    }

    public FolderItemResponse asFolderItemResponse(Folder entity) {
        if (entity == null) {
            return null;
        }
        FolderItemResponse.FolderItemResponseBuilder folderItemResponse = FolderItemResponse.builder();
        folderItemResponse.parentId(this.entityParentFolderId(entity));
        folderItemResponse.id(entity.getId());
        folderItemResponse.name(entity.getName());
        folderItemResponse.description(entity.getDescription());
        folderItemResponse.createdWhen(MapperUtils.fromTimestamp((Timestamp)entity.getCreatedWhen()));
        folderItemResponse.createdBy(this.userMapper.asDTO(entity.getCreatedBy()));
        folderItemResponse.modifiedWhen(MapperUtils.fromTimestamp((Timestamp)entity.getModifiedWhen()));
        folderItemResponse.modifiedBy(this.userMapper.asDTO(entity.getModifiedBy()));
        return folderItemResponse.build();
    }

    public void merge(FolderResponse dto, Folder entity) {
        if (entity == null) {
            return;
        }
        dto.setParentId(this.entityParentFolderId(entity));
        dto.setId(entity.getId());
        dto.setName(entity.getName());
        dto.setDescription(entity.getDescription());
        dto.setCreatedWhen(MapperUtils.fromTimestamp((Timestamp)entity.getCreatedWhen()));
        dto.setCreatedBy(this.userMapper.asDTO(entity.getCreatedBy()));
        dto.setModifiedWhen(MapperUtils.fromTimestamp((Timestamp)entity.getModifiedWhen()));
        dto.setModifiedBy(this.userMapper.asDTO(entity.getModifiedBy()));
    }

    private String entityParentFolderId(Folder folder) {
        if (folder == null) {
            return null;
        }
        Folder parentFolder = folder.getParentFolder();
        if (parentFolder == null) {
            return null;
        }
        String id = parentFolder.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

