/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.LinkedHashSet;
import java.util.Set;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.MaskedField;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.masking.MaskedFieldDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.masking.MaskedFieldsResponse;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.MaskedFieldsMapper;
import org.springframework.stereotype.Component;

@Component
public class MaskedFieldsMapperImpl
implements MaskedFieldsMapper {
    public MaskedFieldsResponse asResponse(Chain entity) {
        if (entity == null) {
            return null;
        }
        MaskedFieldsResponse.MaskedFieldsResponseBuilder maskedFieldsResponse = MaskedFieldsResponse.builder();
        maskedFieldsResponse.fields(this.maskedFieldSetToMaskedFieldDTOSet(entity.getMaskedFields()));
        return maskedFieldsResponse.build();
    }

    public MaskedFieldDTO asDto(MaskedField entity) {
        if (entity == null) {
            return null;
        }
        MaskedFieldDTO.MaskedFieldDTOBuilder maskedFieldDTO = MaskedFieldDTO.builder();
        maskedFieldDTO.id(entity.getId());
        maskedFieldDTO.name(entity.getName());
        maskedFieldDTO.createdWhen(MapperUtils.fromTimestamp((Timestamp)entity.getCreatedWhen()));
        maskedFieldDTO.createdBy(entity.getCreatedBy());
        maskedFieldDTO.modifiedWhen(MapperUtils.fromTimestamp((Timestamp)entity.getModifiedWhen()));
        maskedFieldDTO.modifiedBy(entity.getModifiedBy());
        return maskedFieldDTO.build();
    }

    public MaskedField asEntity(Chain chain, MaskedFieldDTO dto) {
        if (chain == null && dto == null) {
            return null;
        }
        MaskedField.MaskedFieldBuilder maskedField = MaskedField.builder();
        if (dto != null) {
            maskedField.name(dto.getName());
            maskedField.createdBy(dto.getCreatedBy());
            maskedField.createdWhen(MapperUtils.toTimestamp((Long)dto.getCreatedWhen()));
            maskedField.modifiedBy(dto.getModifiedBy());
            maskedField.modifiedWhen(MapperUtils.toTimestamp((Long)dto.getModifiedWhen()));
        }
        maskedField.chain(chain);
        return maskedField.build();
    }

    public MaskedField asEntity(MaskedFieldDTO dto) {
        if (dto == null) {
            return null;
        }
        MaskedField.MaskedFieldBuilder maskedField = MaskedField.builder();
        maskedField.id(dto.getId());
        maskedField.name(dto.getName());
        maskedField.createdWhen(MapperUtils.toTimestamp((Long)dto.getCreatedWhen()));
        maskedField.modifiedWhen(MapperUtils.toTimestamp((Long)dto.getModifiedWhen()));
        maskedField.createdBy(dto.getCreatedBy());
        maskedField.modifiedBy(dto.getModifiedBy());
        return maskedField.build();
    }

    protected Set<MaskedFieldDTO> maskedFieldSetToMaskedFieldDTOSet(Set<MaskedField> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<MaskedFieldDTO> set1 = new LinkedHashSet<MaskedFieldDTO>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (MaskedField maskedField : set) {
            set1.add(this.asDto(maskedField));
        }
        return set1;
    }
}

