/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.qubership.integration.platform.catalog.model.dto.BaseResponse;
import org.qubership.integration.platform.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroupLabel;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SpecificationGroupDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SpecificationGroupLabelDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SpecificationGroupRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainBaseMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.SpecificationGroupMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.SystemModelBaseMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpecificationGroupMapperImpl
implements SpecificationGroupMapper {
    @Autowired
    private SystemModelBaseMapper systemModelBaseMapper;
    @Autowired
    private ChainBaseMapper chainBaseMapper;

    public SpecificationGroupDTO toSpecificationGroupDTO(SpecificationGroup specificationGroup) {
        if (specificationGroup == null) {
            return null;
        }
        SpecificationGroupDTO specificationGroupDTO = new SpecificationGroupDTO();
        specificationGroupDTO.setSystemId(this.specificationGroupSystemId(specificationGroup));
        specificationGroupDTO.setSpecifications(this.systemModelBaseMapper.toDTOs(specificationGroup.getSystemModels()));
        specificationGroupDTO.setId(specificationGroup.getId());
        specificationGroupDTO.setName(specificationGroup.getName());
        specificationGroupDTO.setUrl(specificationGroup.getUrl());
        specificationGroupDTO.setSynchronization(specificationGroup.isSynchronization());
        specificationGroupDTO.setCreatedWhen(MapperUtils.fromTimestamp((Timestamp)specificationGroup.getCreatedWhen()));
        specificationGroupDTO.setCreatedBy(this.userToUserDTO(specificationGroup.getCreatedBy()));
        specificationGroupDTO.setModifiedWhen(MapperUtils.fromTimestamp((Timestamp)specificationGroup.getModifiedWhen()));
        specificationGroupDTO.setModifiedBy(this.userToUserDTO(specificationGroup.getModifiedBy()));
        specificationGroupDTO.setChains(this.chainBaseMapper.asDTO(specificationGroup.getChains()));
        specificationGroupDTO.setLabels(this.specificationGroupLabelSetToSpecificationGroupLabelDTOList(specificationGroup.getLabels()));
        return specificationGroupDTO;
    }

    public List<SpecificationGroupDTO> toSpecificationGroupDTOs(List<SpecificationGroup> specificationGroups) {
        if (specificationGroups == null) {
            return null;
        }
        ArrayList<SpecificationGroupDTO> list = new ArrayList<SpecificationGroupDTO>(specificationGroups.size());
        for (SpecificationGroup specificationGroup : specificationGroups) {
            list.add(this.toSpecificationGroupDTO(specificationGroup));
        }
        return list;
    }

    public void mergeWithoutLabels(SpecificationGroupDTO specificationGroupDTO, SpecificationGroup specificationGroup) {
        if (specificationGroupDTO == null) {
            return;
        }
        specificationGroup.setId(specificationGroupDTO.getId());
        specificationGroup.setName(specificationGroupDTO.getName());
        specificationGroup.setCreatedWhen(MapperUtils.toTimestamp((Long)specificationGroupDTO.getCreatedWhen()));
        specificationGroup.setModifiedWhen(MapperUtils.toTimestamp((Long)specificationGroupDTO.getModifiedWhen()));
        if (specificationGroupDTO.getCreatedBy() != null) {
            if (specificationGroup.getCreatedBy() == null) {
                specificationGroup.setCreatedBy(User.builder().build());
            }
            this.userDTOToUser(specificationGroupDTO.getCreatedBy(), specificationGroup.getCreatedBy());
        } else {
            specificationGroup.setCreatedBy(null);
        }
        if (specificationGroupDTO.getModifiedBy() != null) {
            if (specificationGroup.getModifiedBy() == null) {
                specificationGroup.setModifiedBy(User.builder().build());
            }
            this.userDTOToUser(specificationGroupDTO.getModifiedBy(), specificationGroup.getModifiedBy());
        } else {
            specificationGroup.setModifiedBy(null);
        }
        if (specificationGroup.getLabels() != null) {
            set = this.specificationGroupLabelDTOListToSpecificationGroupLabelSet(specificationGroupDTO.getLabels());
            if (set != null) {
                specificationGroup.getLabels().clear();
                specificationGroup.getLabels().addAll(set);
            } else {
                specificationGroup.setLabels(null);
            }
        } else {
            set = this.specificationGroupLabelDTOListToSpecificationGroupLabelSet(specificationGroupDTO.getLabels());
            if (set != null) {
                specificationGroup.setLabels(set);
            }
        }
        specificationGroup.setUrl(specificationGroupDTO.getUrl());
        specificationGroup.setSynchronization(specificationGroupDTO.isSynchronization());
        if (specificationGroup.getChains() != null) {
            list = this.baseResponseListToChainList(specificationGroupDTO.getChains());
            if (list != null) {
                specificationGroup.getChains().clear();
                specificationGroup.getChains().addAll(list);
            } else {
                specificationGroup.setChains(null);
            }
        } else {
            list = this.baseResponseListToChainList(specificationGroupDTO.getChains());
            if (list != null) {
                specificationGroup.setChains(list);
            }
        }
    }

    public void mergeWithoutLabels(SpecificationGroupRequestDTO specificationGroupDTO, SpecificationGroup specificationGroup) {
        if (specificationGroupDTO == null) {
            return;
        }
        specificationGroup.setSynchronization(specificationGroupDTO.isSynchronization());
    }

    public SpecificationGroupLabel asLabelRequest(SpecificationGroupLabelDTO snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        SpecificationGroupLabel.SpecificationGroupLabelBuilder specificationGroupLabel = SpecificationGroupLabel.builder();
        specificationGroupLabel.name(snapshotLabel.getName());
        if (snapshotLabel.getTechnical() != null) {
            specificationGroupLabel.technical(snapshotLabel.getTechnical().booleanValue());
        }
        return specificationGroupLabel.build();
    }

    public List<SpecificationGroupLabel> asLabelRequests(List<SpecificationGroupLabelDTO> snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        ArrayList<SpecificationGroupLabel> list = new ArrayList<SpecificationGroupLabel>(snapshotLabel.size());
        for (SpecificationGroupLabelDTO specificationGroupLabelDTO : snapshotLabel) {
            list.add(this.asLabelRequest(specificationGroupLabelDTO));
        }
        return list;
    }

    public SpecificationGroupLabelDTO asLabelResponse(SpecificationGroupLabel snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        SpecificationGroupLabelDTO.SpecificationGroupLabelDTOBuilder specificationGroupLabelDTO = SpecificationGroupLabelDTO.builder();
        specificationGroupLabelDTO.name(snapshotLabel.getName());
        specificationGroupLabelDTO.technical(Boolean.valueOf(snapshotLabel.isTechnical()));
        return specificationGroupLabelDTO.build();
    }

    public List<SpecificationGroupLabelDTO> asLabelResponse(List<SpecificationGroupLabel> snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        ArrayList<SpecificationGroupLabelDTO> list = new ArrayList<SpecificationGroupLabelDTO>(snapshotLabel.size());
        for (SpecificationGroupLabel specificationGroupLabel : snapshotLabel) {
            list.add(this.asLabelResponse(specificationGroupLabel));
        }
        return list;
    }

    private String specificationGroupSystemId(SpecificationGroup specificationGroup) {
        if (specificationGroup == null) {
            return null;
        }
        IntegrationSystem system = specificationGroup.getSystem();
        if (system == null) {
            return null;
        }
        String id = system.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    protected UserDTO userToUserDTO(User user) {
        if (user == null) {
            return null;
        }
        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();
        userDTO.id(user.getId());
        userDTO.username(user.getUsername());
        return userDTO.build();
    }

    protected List<SpecificationGroupLabelDTO> specificationGroupLabelSetToSpecificationGroupLabelDTOList(Set<SpecificationGroupLabel> set) {
        if (set == null) {
            return null;
        }
        ArrayList<SpecificationGroupLabelDTO> list = new ArrayList<SpecificationGroupLabelDTO>(set.size());
        for (SpecificationGroupLabel specificationGroupLabel : set) {
            list.add(this.asLabelResponse(specificationGroupLabel));
        }
        return list;
    }

    protected void userDTOToUser(UserDTO userDTO, User mappingTarget) {
        if (userDTO == null) {
            return;
        }
        mappingTarget.setId(userDTO.getId());
        mappingTarget.setUsername(userDTO.getUsername());
    }

    protected Set<SpecificationGroupLabel> specificationGroupLabelDTOListToSpecificationGroupLabelSet(List<SpecificationGroupLabelDTO> list) {
        if (list == null) {
            return null;
        }
        LinkedHashSet<SpecificationGroupLabel> set = new LinkedHashSet<SpecificationGroupLabel>(Math.max((int)((float)list.size() / 0.75f) + 1, 16));
        for (SpecificationGroupLabelDTO specificationGroupLabelDTO : list) {
            set.add(this.asLabelRequest(specificationGroupLabelDTO));
        }
        return set;
    }

    protected User userDTOToUser1(UserDTO userDTO) {
        if (userDTO == null) {
            return null;
        }
        User.UserBuilder user = User.builder();
        user.id(userDTO.getId());
        user.username(userDTO.getUsername());
        return user.build();
    }

    protected Chain baseResponseToChain(BaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        Chain.ChainBuilder chain = Chain.builder();
        chain.id(baseResponse.getId());
        chain.name(baseResponse.getName());
        chain.description(baseResponse.getDescription());
        chain.createdWhen(MapperUtils.toTimestamp((Long)baseResponse.getCreatedWhen()));
        chain.modifiedWhen(MapperUtils.toTimestamp((Long)baseResponse.getModifiedWhen()));
        chain.createdBy(this.userDTOToUser1(baseResponse.getCreatedBy()));
        chain.modifiedBy(this.userDTOToUser1(baseResponse.getModifiedBy()));
        return chain.build();
    }

    protected List<Chain> baseResponseListToChainList(List<BaseResponse> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Chain> list1 = new ArrayList<Chain>(list.size());
        for (BaseResponse baseResponse : list) {
            list1.add(this.baseResponseToChain(baseResponse));
        }
        return list1;
    }
}

