/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.qubership.integration.platform.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModelLabel;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SystemModelBaseDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SystemModelLabelDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainBaseMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.SystemModelBaseMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemModelBaseMapperImpl
implements SystemModelBaseMapper {
    @Autowired
    private ChainBaseMapper chainBaseMapper;

    public SystemModelBaseDTO toDTO(SystemModel systemModel) {
        if (systemModel == null) {
            return null;
        }
        SystemModelBaseDTO systemModelBaseDTO = new SystemModelBaseDTO();
        systemModelBaseDTO.setSpecificationGroupId(this.systemModelSpecificationGroupId(systemModel));
        systemModelBaseDTO.setSystemId(this.systemModelSpecificationGroupSystemId(systemModel));
        systemModelBaseDTO.setId(systemModel.getId());
        systemModelBaseDTO.setDescription(systemModel.getDescription());
        systemModelBaseDTO.setName(systemModel.getName());
        systemModelBaseDTO.setDeprecated(Boolean.valueOf(systemModel.isDeprecated()));
        systemModelBaseDTO.setVersion(systemModel.getVersion());
        if (systemModel.getSource() != null) {
            systemModelBaseDTO.setSource(systemModel.getSource().name());
        }
        systemModelBaseDTO.setCreatedWhen(MapperUtils.fromTimestamp((Timestamp)systemModel.getCreatedWhen()));
        systemModelBaseDTO.setCreatedBy(this.userToUserDTO(systemModel.getCreatedBy()));
        systemModelBaseDTO.setModifiedWhen(MapperUtils.fromTimestamp((Timestamp)systemModel.getModifiedWhen()));
        systemModelBaseDTO.setModifiedBy(this.userToUserDTO(systemModel.getModifiedBy()));
        systemModelBaseDTO.setChains(this.chainBaseMapper.asDTO(systemModel.getChains()));
        systemModelBaseDTO.setLabels(this.systemModelLabelSetToSystemModelLabelDTOList(systemModel.getLabels()));
        return systemModelBaseDTO;
    }

    public List<SystemModelBaseDTO> toDTOs(List<SystemModel> systemModels) {
        if (systemModels == null) {
            return null;
        }
        ArrayList<SystemModelBaseDTO> list = new ArrayList<SystemModelBaseDTO>(systemModels.size());
        for (SystemModel systemModel : systemModels) {
            list.add(this.toDTO(systemModel));
        }
        return list;
    }

    public SystemModelLabel asLabelRequest(SystemModelLabelDTO snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        SystemModelLabel.SystemModelLabelBuilder systemModelLabel = SystemModelLabel.builder();
        systemModelLabel.name(snapshotLabel.getName());
        if (snapshotLabel.getTechnical() != null) {
            systemModelLabel.technical(snapshotLabel.getTechnical().booleanValue());
        }
        return systemModelLabel.build();
    }

    public List<SystemModelLabel> asLabelRequests(List<SystemModelLabelDTO> snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        ArrayList<SystemModelLabel> list = new ArrayList<SystemModelLabel>(snapshotLabel.size());
        for (SystemModelLabelDTO systemModelLabelDTO : snapshotLabel) {
            list.add(this.asLabelRequest(systemModelLabelDTO));
        }
        return list;
    }

    public SystemModelLabelDTO asLabelResponse(SystemModelLabel snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        SystemModelLabelDTO.SystemModelLabelDTOBuilder systemModelLabelDTO = SystemModelLabelDTO.builder();
        systemModelLabelDTO.name(snapshotLabel.getName());
        systemModelLabelDTO.technical(Boolean.valueOf(snapshotLabel.isTechnical()));
        return systemModelLabelDTO.build();
    }

    public List<SystemModelLabelDTO> asLabelResponse(List<SystemModelLabel> snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        ArrayList<SystemModelLabelDTO> list = new ArrayList<SystemModelLabelDTO>(snapshotLabel.size());
        for (SystemModelLabel systemModelLabel : snapshotLabel) {
            list.add(this.asLabelResponse(systemModelLabel));
        }
        return list;
    }

    private String systemModelSpecificationGroupId(SystemModel systemModel) {
        if (systemModel == null) {
            return null;
        }
        SpecificationGroup specificationGroup = systemModel.getSpecificationGroup();
        if (specificationGroup == null) {
            return null;
        }
        String id = specificationGroup.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String systemModelSpecificationGroupSystemId(SystemModel systemModel) {
        if (systemModel == null) {
            return null;
        }
        SpecificationGroup specificationGroup = systemModel.getSpecificationGroup();
        if (specificationGroup == null) {
            return null;
        }
        IntegrationSystem system = specificationGroup.getSystem();
        if (system == null) {
            return null;
        }
        String id = system.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    protected UserDTO userToUserDTO(User user) {
        if (user == null) {
            return null;
        }
        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();
        userDTO.id(user.getId());
        userDTO.username(user.getUsername());
        return userDTO.build();
    }

    protected List<SystemModelLabelDTO> systemModelLabelSetToSystemModelLabelDTOList(Set<SystemModelLabel> set) {
        if (set == null) {
            return null;
        }
        ArrayList<SystemModelLabelDTO> list = new ArrayList<SystemModelLabelDTO>(set.size());
        for (SystemModelLabel systemModelLabel : set) {
            list.add(this.asLabelResponse(systemModelLabel));
        }
        return list;
    }
}

