/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.scheduler;

import jakarta.transaction.Transactional;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.catalog.consul.ConsulService;
import org.qubership.integration.platform.catalog.consul.exception.KVNotFoundException;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.designtime.catalog.service.ChainRuntimePropertiesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TasksScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TasksScheduler.class);
    private final ActionsLogService actionsLogService;
    private final ConsulService consulService;
    private final ChainRuntimePropertiesService chainRuntimePropertiesService;
    @Value(value="${qip.actions-log.cleanup.interval}")
    private String actionLogInterval;

    @Autowired
    public TasksScheduler(ActionsLogService actionsLogService, ConsulService consulService, ChainRuntimePropertiesService chainRuntimePropertiesService) {
        this.actionsLogService = actionsLogService;
        this.consulService = consulService;
        this.chainRuntimePropertiesService = chainRuntimePropertiesService;
    }

    @Scheduled(cron="${qip.actions-log.cleanup.cron}")
    @Transactional
    public void cleanupActionsLog() {
        this.actionsLogService.deleteAllOldRecordsByInterval(this.actionLogInterval);
        log.info("Remove old records from actions log table");
    }

    @Scheduled(fixedDelay=1000L)
    public void checkRuntimeDeploymentProperties() {
        try {
            Pair response = this.consulService.waitForChainRuntimeConfig();
            if (((Boolean)response.getLeft()).booleanValue()) {
                this.chainRuntimePropertiesService.updateCache((Map)response.getRight());
            }
        }
        catch (KVNotFoundException kvnfe) {
            log.debug("Runtime deployments properties KV is empty. {}", (Object)kvnfe.getMessage());
            this.chainRuntimePropertiesService.updateCache(Collections.emptyMap());
        }
        catch (Exception e) {
            log.error("Failed to get runtime deployments properties from consul", (Throwable)e);
            this.consulService.rollbackChainsRuntimeConfigLastIndex();
        }
    }
}

