/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.qubership.integration.platform.catalog.consul.ConsulService;
import org.qubership.integration.platform.catalog.model.deployment.properties.DeploymentRuntimeProperties;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ChainRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.logging.properties.ChainLoggingPropertiesSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChainRuntimePropertiesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChainRuntimePropertiesService.class);
    public static final String DEFAULT_CONSUL_SETTING_KEY = "default-settings";
    private Map<String, DeploymentRuntimeProperties> runtimePropertiesCache = Collections.emptyMap();
    private final ConsulService consulService;
    private final ActionsLogService actionLogger;
    private final ChainRepository chainRepository;

    @Autowired
    public ChainRuntimePropertiesService(ConsulService consulService, ActionsLogService actionLogger, ChainRepository chainRepository) {
        this.consulService = consulService;
        this.actionLogger = actionLogger;
        this.chainRepository = chainRepository;
    }

    public void saveRuntimeProperties(String chainId, DeploymentRuntimeProperties request) {
        this.consulService.updateChainRuntimeConfig(chainId, request);
        this.logChainAction(chainId, LogOperation.CREATE_OR_UPDATE);
    }

    public void deleteCustomRuntimeProperties(String chainId) {
        this.consulService.deleteChainRuntimeConfig(chainId);
        this.logChainAction(chainId, LogOperation.DELETE);
    }

    public ChainLoggingPropertiesSet getRuntimeProperties(String chainId) {
        ChainLoggingPropertiesSet.ChainLoggingPropertiesSetBuilder builder = ChainLoggingPropertiesSet.builder().fallbackDefault(DeploymentRuntimeProperties.getDefaultValues());
        if (chainId != null && this.runtimePropertiesCache != null) {
            if (this.runtimePropertiesCache.containsKey(chainId)) {
                builder.custom((DeploymentRuntimeProperties)this.runtimePropertiesCache.get(chainId));
            }
            if (this.runtimePropertiesCache.containsKey(DEFAULT_CONSUL_SETTING_KEY)) {
                builder.consulDefault((DeploymentRuntimeProperties)this.runtimePropertiesCache.get(DEFAULT_CONSUL_SETTING_KEY));
            }
        }
        return builder.build();
    }

    public Map<String, DeploymentRuntimeProperties> getRuntimePropertiesCache() {
        if (this.runtimePropertiesCache != null && !this.runtimePropertiesCache.isEmpty()) {
            return this.runtimePropertiesCache;
        }
        return Collections.emptyMap();
    }

    public void updateCache(Map<String, DeploymentRuntimeProperties> propertiesMap) {
        this.runtimePropertiesCache = propertiesMap;
    }

    private void logChainAction(String chainId, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.CHAIN_RUNTIME_PROPERTIES).parentType(EntityType.CHAIN).parentId(chainId).parentName((String)this.chainRepository.findById((Object)chainId).map(AbstractEntity::getName).orElse(null)).operation(operation).build());
    }
}

