/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.criteria.Expression;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.qubership.integration.platform.catalog.model.dto.system.UsedSystem;
import org.qubership.integration.platform.catalog.model.filter.FilterCondition;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.ChainLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ChainLabelsRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ChainRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.DependencyRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.MaskedFieldRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.ChainBaseService;
import org.qubership.integration.platform.catalog.service.ElementBaseService;
import org.qubership.integration.platform.catalog.util.ChainUtils;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.designtime.catalog.configuration.aspect.ChainModification;
import org.qubership.integration.platform.designtime.catalog.model.enums.filter.FilterFeature;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainSearchRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderContentFilter;
import org.qubership.integration.platform.designtime.catalog.service.ChainRuntimePropertiesService;
import org.qubership.integration.platform.designtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.designtime.catalog.service.ElementService;
import org.qubership.integration.platform.designtime.catalog.service.FolderService;
import org.qubership.integration.platform.designtime.catalog.service.filter.ChainFilterSpecificationBuilder;
import org.qubership.integration.platform.designtime.catalog.service.filter.complex.ChainStatusFilters;
import org.qubership.integration.platform.designtime.catalog.service.filter.complex.ElementFilter;
import org.qubership.integration.platform.designtime.catalog.service.filter.complex.LoggingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class ChainService
extends ChainBaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChainService.class);
    private static final String CHAIN_WITH_ID_NOT_FOUND_MESSAGE = "Can't find chain with id: ";
    private static final String CHAIN_TRIGGER = "chain-trigger-2";
    private final ChainRepository chainRepository;
    private final ElementRepository elementRepository;
    private final MaskedFieldRepository maskedFieldRepository;
    private final DependencyRepository dependencyRepository;
    private final ChainLabelsRepository chainLabelsRepository;
    private final FolderService folderService;
    private final ElementService elementService;
    private final DeploymentService deploymentService;
    private final ActionsLogService actionLogger;
    private final ElementUtils elementUtils;
    private final ChainRuntimePropertiesService chainRuntimePropertiesService;
    private final ChainFilterSpecificationBuilder chainFilterSpecificationBuilder;
    private final AuditingHandler auditingHandler;

    @Autowired
    public ChainService(ChainRepository chainRepository, ElementRepository elementRepository, MaskedFieldRepository maskedFieldRepository, DependencyRepository dependencyRepository, ChainLabelsRepository chainLabelsRepository, ElementService elementService, FolderService folderService, @Lazy DeploymentService deploymentService, ActionsLogService actionLogger, ElementUtils elementUtils, ChainFilterSpecificationBuilder chainFilterSpecificationBuilder, AuditingHandler jpaAuditingHandler, ChainRuntimePropertiesService chainRuntimePropertiesService) {
        super(chainRepository, (ElementBaseService)elementService);
        this.chainLabelsRepository = chainLabelsRepository;
        this.folderService = folderService;
        this.elementService = elementService;
        this.chainRepository = chainRepository;
        this.elementRepository = elementRepository;
        this.maskedFieldRepository = maskedFieldRepository;
        this.dependencyRepository = dependencyRepository;
        this.deploymentService = deploymentService;
        this.actionLogger = actionLogger;
        this.elementUtils = elementUtils;
        this.chainFilterSpecificationBuilder = chainFilterSpecificationBuilder;
        this.auditingHandler = jpaAuditingHandler;
        this.chainRuntimePropertiesService = chainRuntimePropertiesService;
    }

    public List<Chain> findAll() {
        return this.chainRepository.findAll();
    }

    public Chain findById(String chainId) {
        return (Chain)this.chainRepository.findById((Object)chainId).orElseThrow(() -> new EntityNotFoundException(CHAIN_WITH_ID_NOT_FOUND_MESSAGE + chainId));
    }

    public Map<String, String> provideNavigationPath(String chainId) {
        Chain chain = this.findById(chainId);
        return chain.getAncestors();
    }

    public List<Chain> findChainsInFolder(String folderId, FolderContentFilter filter) {
        Specification specification = (root, query, criteriaBuilder) -> criteriaBuilder.equal((Expression)root.get("parentFolder").get("id"), (Object)folderId);
        if (Objects.nonNull(filter)) {
            specification = specification.and(filter.getSpecification());
        }
        return this.chainRepository.findAll(specification);
    }

    public List<Chain> findBySystemAndOperationId(String systemId, String operationId) {
        List elements = this.elementService.findBySystemIdAndOperationId(systemId, operationId);
        return this.getElementsChains(elements);
    }

    public List<Chain> findBySystemAndModelId(String systemId, String modelId) {
        List elements = this.elementService.findBySystemAndModelId(systemId, modelId);
        return this.getElementsChains(elements);
    }

    public List<Chain> findBySystemAndGroupId(String systemId, String specificationGroupId) {
        List elements = this.elementService.findBySystemIdAndSpecificationGroupId(systemId, specificationGroupId);
        return this.getElementsChains(elements);
    }

    public Map<String, List<Chain>> findBySystemIdGroupBySpecificationGroup(String systemId) {
        List elements = this.elementService.findBySystemId(systemId);
        HashMap<String, List> specGroupChainElement = new HashMap<String, List>();
        for (ChainElement element : elements) {
            String specificationGroupKey = (String)element.getProperty("integrationSpecificationGroupId");
            if (specificationGroupKey == null) continue;
            specGroupChainElement.computeIfAbsent(specificationGroupKey, s -> new ArrayList()).add(element);
        }
        HashMap<String, List<Chain>> specGroupChains = new HashMap<String, List<Chain>>();
        specGroupChainElement.forEach((key, chainElements) -> specGroupChains.put((String)key, this.getElementsChains(chainElements)));
        return specGroupChains;
    }

    public List<Chain> findInRoot(FolderContentFilter filter) {
        Specification specification = (root, query, criteriaBuilder) -> criteriaBuilder.isNull((Expression)root.get("parentFolder"));
        if (Objects.nonNull(filter)) {
            specification = specification.and(filter.getSpecification());
        }
        return this.chainRepository.findAll(specification);
    }

    public Map<String, String> getNamesMapByChainIds(Set<String> chainIds) {
        return this.chainRepository.findAllById(chainIds).stream().collect(Collectors.toMap(AbstractEntity::getId, AbstractEntity::getName));
    }

    public List<Chain> searchChains(ChainSearchRequestDTO systemSearchRequestDTO) {
        List<FilterRequestDTO> filters = Stream.of(FilterFeature.ID, FilterFeature.NAME, FilterFeature.DESCRIPTION, FilterFeature.PATH, FilterFeature.METHOD, FilterFeature.EXCHANGE, FilterFeature.TOPIC, FilterFeature.QUEUE, FilterFeature.LABELS, FilterFeature.CLASSIFIER).map(feature -> FilterRequestDTO.builder().feature(feature).value(systemSearchRequestDTO.getSearchCondition()).condition(FilterCondition.CONTAINS).build()).toList();
        Specification specification = this.chainFilterSpecificationBuilder.buildSearch(filters);
        return this.chainRepository.findAll(specification);
    }

    public List<Chain> findByFilterRequest(List<FilterRequestDTO> filters) {
        Specification specification = this.chainFilterSpecificationBuilder.buildFilter(filters);
        List chains = this.chainRepository.findAll(specification);
        return this.applyComplexFilters(chains, filters);
    }

    public List<Chain> applyComplexFilters(List<Chain> chains, List<FilterRequestDTO> filters) {
        chains = new ChainStatusFilters(this.deploymentService).apply(chains, filters);
        chains = new ElementFilter().apply(chains, filters);
        chains = new LoggingFilter(this.chainRuntimePropertiesService).apply(chains, filters);
        return chains;
    }

    @ChainModification
    public Chain update(Chain chain, List<ChainLabel> newLabels, String parentFolderId) {
        this.auditingHandler.markModified((Object)chain);
        Chain savedChain = this.upsertChain(chain, newLabels, parentFolderId);
        this.logChainAction(savedChain, LogOperation.UPDATE);
        return savedChain;
    }

    @ChainModification
    public Chain save(Chain chain, String parentFolderId) {
        this.auditingHandler.markModified((Object)chain);
        Chain savedChain = this.upsertChain(chain, null, parentFolderId);
        this.logChainAction(savedChain, LogOperation.CREATE);
        return savedChain;
    }

    public Chain save(Chain chain) {
        return this.save(chain, null);
    }

    private Chain upsertChain(Chain chain, List<ChainLabel> newLabels, String parentFolderId) {
        chain = (Chain)this.chainRepository.save((Object)chain);
        if (parentFolderId != null) {
            Folder parentFolder = this.folderService.findEntityByIdOrNull(parentFolderId);
            parentFolder.addChildChain(chain);
        }
        if (newLabels != null) {
            this.replaceLabels(chain, newLabels);
        }
        return chain;
    }

    private void replaceLabels(Chain chain, List<ChainLabel> newLabels) {
        List finalNewLabels = newLabels;
        Chain finalChain = chain;
        finalNewLabels.forEach(label -> label.setChain(finalChain));
        chain.getLabels().removeIf(l -> !l.isTechnical() && !finalNewLabels.stream().map(AbstractLabel::getName).collect(Collectors.toSet()).contains(l.getName()));
        finalNewLabels.removeIf(l -> l.isTechnical() || finalChain.getLabels().stream().filter(lab -> !lab.isTechnical()).map(AbstractLabel::getName).collect(Collectors.toSet()).contains(l.getName()));
        newLabels = this.chainLabelsRepository.saveAll(finalNewLabels);
        chain.addLabels((Collection)newLabels);
    }

    public void deleteById(String chainId) {
        this.deploymentService.deleteAllByChainId(chainId);
        Chain chain = this.findById(chainId);
        if (chain.getOverriddenByChain() != null) {
            Chain chainThatOverrides = chain.getOverriddenByChain();
            chainThatOverrides.getLabels().removeIf(label -> "Overrides".equals(label.getName()));
            chainThatOverrides.setOverridesChainId(null);
            this.chainRepository.save((Object)chainThatOverrides);
        }
        if (chain.getOverridesChain() != null) {
            Chain overriddenChain = chain.getOverridesChain();
            overriddenChain.getLabels().removeIf(label -> "Overridden".equals(label.getName()));
            overriddenChain.setOverriddenByChainId(null);
            this.chainRepository.save((Object)overriddenChain);
        }
        this.chainRepository.deleteById((Object)chainId);
        this.logChainAction(chain, LogOperation.DELETE);
    }

    public List<UsedSystem> getUsedSystemIdsByChainIds(List<String> chainIds) {
        if (CollectionUtils.isEmpty(chainIds)) {
            return this.elementService.getAllUsedSystemIds();
        }
        return this.elementService.getUsedSystemIdsByChainIds(chainIds);
    }

    public Chain move(String chainId, String targetFolderId) {
        Chain chain = this.findById(chainId);
        chain.setParentFolder(this.folderService.findEntityByIdOrNull(targetFolderId));
        this.logChainAction(chain, LogOperation.MOVE);
        return chain;
    }

    public Chain copy(String chainId, String targetFolderId) {
        return this.copy(this.findById(chainId), this.folderService.findEntityByIdOrNull(targetFolderId));
    }

    @ChainModification
    public Chain copy(Chain chain, Folder parentFolder) {
        Chain chainCopy = ChainUtils.getChainCopy((Chain)chain);
        chainCopy.setId(UUID.randomUUID().toString());
        chainCopy.setParentFolder(parentFolder);
        chainCopy.setName(this.generateCopyName(chainCopy, parentFolder == null ? null : parentFolder.getId()));
        chainCopy.setSnapshots(new ArrayList());
        chainCopy.setCurrentSnapshot(null);
        chainCopy.setDeployments(new ArrayList());
        chainCopy.setElements(this.copyElements(chainCopy.getElements(), chainCopy.getId()));
        Set elementsModifiedState = this.saveElementsModifiedState(chainCopy.getElements());
        this.restoreElementsModifiedState(elementsModifiedState, chainCopy.getElements());
        chainCopy.setLabels(new HashSet());
        Set chainLabelsCopy = chain.getLabels().stream().map(label -> new ChainLabel(label.getName(), chainCopy)).collect(Collectors.toSet());
        chainCopy.setLabels(chainLabelsCopy);
        chainCopy.getDependencies().forEach(arg_0 -> ((DependencyRepository)this.dependencyRepository).saveEntity(arg_0));
        chainCopy.getMaskedFields().forEach(arg_0 -> ((MaskedFieldRepository)this.maskedFieldRepository).saveEntity(arg_0));
        chainCopy.getElements().forEach(arg_0 -> ((ElementRepository)this.elementRepository).saveEntity(arg_0));
        this.chainRepository.saveEntity((Object)chainCopy);
        return chainCopy;
    }

    private void logChainAction(Chain chain, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.CHAIN).entityId(chain.getId()).entityName(chain.getName()).parentType(chain.getParentFolder() == null ? null : EntityType.FOLDER).parentId(chain.getParentFolder() == null ? null : chain.getParentFolder().getId()).parentName(chain.getParentFolder() == null ? null : chain.getParentFolder().getName()).operation(operation).build());
    }

    public Chain duplicate(String chainId) {
        Chain chain = this.findById(chainId);
        Folder parentFolder = chain.getParentFolder();
        return this.copy(chain, parentFolder);
    }

    private String generateCopyName(Chain chainCopy, String targetFolderId) {
        Object newName = chainCopy.getName();
        if (this.chainRepository.existsByNameAndParentFolderId((String)newName, targetFolderId)) {
            int copyNumber = 1;
            String tempName = (String)newName + " (" + copyNumber + ")";
            while (this.chainRepository.existsByNameAndParentFolderId(tempName, targetFolderId)) {
                tempName = (String)newName + " (" + ++copyNumber + ")";
            }
            newName = (String)newName + " (" + copyNumber + ")";
        }
        return newName;
    }

    private void restoreElementsModifiedState(Set<String> elementsModifiedState, List<ChainElement> elements) {
        for (ChainElement element : elements) {
            if (elementsModifiedState.contains(element.getId())) {
                element.setCreatedWhen(null);
                element.setModifiedWhen(null);
                continue;
            }
            element.setModifiedWhen(Timestamp.valueOf(LocalDateTime.now()));
        }
    }

    private Set<String> saveElementsModifiedState(List<ChainElement> elements) {
        HashSet<String> elementsModifiedState = new HashSet<String>();
        for (ChainElement element : elements) {
            if (element.getCreatedWhen() != null) continue;
            elementsModifiedState.add(element.getId());
        }
        return elementsModifiedState;
    }

    private void setDependencies(List<ChainElement> originalElements, Map<String, ChainElement> elementsMap) {
        for (ChainElement originalElement : originalElements) {
            ChainElement copiedElement = elementsMap.get(originalElement.getId());
            List<String> inputIdList = originalElement.getInputDependencies().stream().map(dep -> dep.getElementFrom().getId()).filter(elId -> ((ChainElement)elementsMap.get(elId)).getOutputDependencies().isEmpty()).toList();
            List<String> outputIdList = originalElement.getOutputDependencies().stream().map(dep -> dep.getElementTo().getId()).filter(elId -> ((ChainElement)elementsMap.get(elId)).getInputDependencies().isEmpty()).toList();
            List inputDependencies = inputIdList.stream().map(elementId -> {
                ChainElement element = (ChainElement)elementsMap.get(elementId);
                return Dependency.of((ChainElement)element, (ChainElement)copiedElement);
            }).collect(Collectors.toList());
            List outputDependencies = outputIdList.stream().map(elementId -> {
                ChainElement element = (ChainElement)elementsMap.get(elementId);
                return Dependency.of((ChainElement)copiedElement, (ChainElement)element);
            }).collect(Collectors.toList());
            copiedElement.setInputDependencies(inputDependencies);
            copiedElement.setOutputDependencies(outputDependencies);
        }
    }

    public List<ChainElement> copyElements(List<ChainElement> originalElements, String chainId) {
        HashMap<String, ChainElement> copiedElementsMap = new HashMap<String, ChainElement>();
        HashMap<String, ChainElement> originalElementsMap = new HashMap<String, ChainElement>();
        ArrayList<ChainElement> copiedElements = new ArrayList<ChainElement>();
        for (ChainElement chainElement : originalElements) {
            chainElement.setId(UUID.randomUUID().toString());
            this.elementUtils.updateResetOnCopyProperties(chainElement, chainId);
            copiedElementsMap.put(chainElement.getId(), chainElement);
            originalElementsMap.put(chainElement.getId(), chainElement);
            copiedElements.add(chainElement);
        }
        for (Map.Entry entry : copiedElementsMap.entrySet()) {
            ContainerChainElement parent = ((ChainElement)originalElementsMap.get(entry.getKey())).getParent();
            if (parent == null) continue;
            ((ChainElement)entry.getValue()).setParent((ContainerChainElement)copiedElementsMap.get(parent.getId()));
        }
        this.setDependencies(originalElements, copiedElementsMap);
        return copiedElements;
    }

    private ChainElement copyElement(ChainElement originalElement) {
        ChainElement copiedElement = this.createChainElement(originalElement);
        if (originalElement.getCreatedWhen().getTime() == originalElement.getModifiedWhen().getTime()) {
            copiedElement.setCreatedWhen(null);
            copiedElement.setModifiedWhen(null);
        } else {
            copiedElement.setModifiedWhen(Timestamp.valueOf(LocalDateTime.now()));
        }
        return copiedElement;
    }

    public ChainElement createChainElement(ChainElement base) {
        ChainElement element = base.copy();
        if (CHAIN_TRIGGER.equals(element.getType())) {
            element.getProperties().put("elementId", element.getId());
        }
        element = this.elementService.save(element);
        if (base.getModifiedWhen().getTime() == base.getCreatedWhen().getTime()) {
            element.setCreatedWhen(null);
            element.setModifiedWhen(null);
        } else {
            element.setModifiedWhen(Timestamp.valueOf(LocalDateTime.now()));
        }
        element.setOriginalId(null);
        return element;
    }

    public boolean containsDeprecatedElements(Chain chain) {
        return chain.getElements().stream().anyMatch(arg_0 -> ((ElementService)this.elementService).isElementDeprecated(arg_0));
    }

    public boolean containsUnsupportedElements(Chain chain) {
        return chain.getElements().stream().anyMatch(arg_0 -> ((ElementService)this.elementService).isElementUnsupported(arg_0));
    }

    public List<Chain> findAllChainsToRootParentFolder(String openedFolderId) {
        return this.chainRepository.findAllChainsToRootParentFolder(openedFolderId);
    }

    public List<Chain> findAllChainsInFolders(List<String> folderIds) {
        return this.chainRepository.findAllChainsInFolders(folderIds);
    }

    public long getChainsCount() {
        return this.chainRepository.count();
    }
}

