/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.swagger.v3.parser.util.DeserializationUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.model.system.EnvironmentSourceType;
import org.qubership.integration.platform.catalog.model.system.IntegrationSystemType;
import org.qubership.integration.platform.catalog.model.system.OperationProtocol;
import org.qubership.integration.platform.catalog.model.system.SystemModelSource;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.ConfigParameter;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.ConfigParameterService;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.catalog.service.exportimport.SpecificationImportService;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.SpecificationDiscoveryException;
import org.qubership.integration.platform.designtime.catalog.kubernetes.KubeOperator;
import org.qubership.integration.platform.designtime.catalog.model.kubernetes.KubeService;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.discovery.DiscoveredServiceDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.discovery.DiscoveryErrorDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.discovery.DiscoveryResultDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.DiscoveryServiceMapper;
import org.qubership.integration.platform.designtime.catalog.service.DiscoveryService;
import org.qubership.integration.platform.designtime.catalog.service.EnvironmentService;
import org.qubership.integration.platform.designtime.catalog.service.SpecificationGroupService;
import org.qubership.integration.platform.designtime.catalog.service.SystemModelService;
import org.qubership.integration.platform.designtime.catalog.service.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class DiscoveryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscoveryService.class);
    private final KubeOperator operator;
    private final SystemService systemService;
    private final EnvironmentService environmentService;
    private final SystemModelService systemModelService;
    private final SpecificationImportService specificationImportService;
    private final SpecificationGroupService specificationGroupService;
    private final YAMLMapper yamlMapper;
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;
    private final DiscoveryServiceMapper discoveryServiceMapper;
    private final ConfigParameterService configParameterService;
    private final ActionsLogService actionLogger;
    private static final String DISCOVERY_RESULT_NAME = "discoveryResult";
    private static final String DISCOVERY_PROGRESS_NAME = "discoveryProgress";
    private static final String DISCOVERY_NAMESPACE = "discovery";
    private static final String SPEC_FIELD_NAME = "name";
    private static final String SPEC_FIELD_URL = "url";
    private static final String SPEC_FIELD_URL_LIST = "urls";
    private static final String SPEC_FIELD_ID = "id";
    private static final String SPEC_FIELD_VERSION = "version";
    private static final String SPEC_FIELD_INFO = "info";
    private static final String DISCOVERY_COMPLETE = "100";
    private static final String DISCOVERY_START = "0";
    private static final Integer PRIORITY_SERVICE_PORT = 8080;
    private static final Map<OperationProtocol, String> PROTOCOL_POSTFIX_MAP = Map.of(OperationProtocol.HTTP, "", OperationProtocol.KAFKA, "async");
    private double percent;
    private final Object lock = new Object();

    @Autowired
    public DiscoveryService(KubeOperator operator, SystemService systemService, EnvironmentService environmentService, SystemModelService systemModelService, SpecificationImportService specificationImportService, SpecificationGroupService specificationGroupService, YAMLMapper yamlMapper, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper, RestTemplate restTemplateMS, DiscoveryServiceMapper discoveryServiceMapper, ConfigParameterService configParameterService, ActionsLogService actionLogger) {
        this.operator = operator;
        this.systemService = systemService;
        this.environmentService = environmentService;
        this.systemModelService = systemModelService;
        this.specificationImportService = specificationImportService;
        this.specificationGroupService = specificationGroupService;
        this.yamlMapper = yamlMapper;
        this.objectMapper = objectMapper;
        this.restTemplate = restTemplateMS;
        this.discoveryServiceMapper = discoveryServiceMapper;
        this.configParameterService = configParameterService;
        this.actionLogger = actionLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDiscovery() {
        Object object = this.lock;
        synchronized (object) {
            String requestId = MDC.get((String)"requestId");
            if (!this.isDiscoveryComplete()) {
                throw new RuntimeException("Autodiscovery is in progress");
            }
            this.setDiscoveryStatus(DISCOVERY_START);
            CompletableFuture.supplyAsync(() -> {
                MDC.put((String)"requestId", (String)requestId);
                return this.runDiscoveryAsync();
            }).whenCompleteAsync((result, throwable) -> {
                MDC.put((String)"requestId", (String)requestId);
                this.discoveryComplete(result, throwable);
            });
        }
    }

    private void discoveryComplete(DiscoveryResultDTO result, Throwable throwable) {
        String errorMessage = null;
        if (throwable != null) {
            errorMessage = throwable.getMessage();
        }
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.SERVICE_DISCOVERY).operation(LogOperation.EXECUTE).build());
        this.setDiscoveryStatusResult(result, errorMessage);
    }

    private DiscoveryResultDTO runDiscoveryAsync() {
        log.info("Discovery started");
        String requestId = MDC.get((String)"requestId");
        ArrayList<CompletableFuture<List>> newlyDiscoveredFuture = new ArrayList<CompletableFuture<List>>();
        ArrayList<CompletableFuture<SpecificationChanges>> specificationChangedFuture = new ArrayList<CompletableFuture<SpecificationChanges>>();
        ArrayList errorMessages = new ArrayList();
        List systems = this.systemService.getAllDiscoveredServices();
        List services = this.operator.getServices();
        this.percent = 99.0 / (double)(services.size() + systems.size());
        log.debug("Percent step size: {}", (Object)this.percent);
        for (IntegrationSystem system : systems) {
            specificationChangedFuture.add(CompletableFuture.supplyAsync(() -> {
                MDC.put((String)"requestId", (String)requestId);
                return this.makeSpecificationChange(system, errorMessages, services);
            }));
        }
        for (KubeService service : services) {
            newlyDiscoveredFuture.add(CompletableFuture.supplyAsync(() -> {
                MDC.put((String)"requestId", (String)requestId);
                return this.createDiscoveredService(service, errorMessages);
            }));
        }
        return this.toDiscoveryResultDTO(this.getFuturesResultFlat(newlyDiscoveredFuture), this.getFuturesResult(specificationChangedFuture), errorMessages);
    }

    private <T> List<T> getFuturesResult(List<CompletableFuture<T>> futureList) {
        return futureList.stream().filter(Objects::nonNull).map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T> List<T> getFuturesResultFlat(List<CompletableFuture<List<T>>> futureLists) {
        return this.getFuturesResult(futureLists).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private SpecificationChanges makeSpecificationChange(IntegrationSystem system, List<SpecificationDiscoveryErrorMsg> errorMessages, List<KubeService> services) {
        List ignoreUrl = Collections.emptyList();
        if (system.getSpecificationGroups() != null) {
            ignoreUrl = system.getSpecificationGroups().stream().filter(group -> !group.isSynchronization()).map(SpecificationGroup::getUrl).filter(Objects::nonNull).collect(Collectors.toList());
        }
        KubeService service = this.findCorrespondingService(system, services);
        SpecificationDiscoveryResult specificationDiscoveryResult = null;
        if (service != null) {
            specificationDiscoveryResult = this.runSpecificationDiscovery(service.getName(), service.getPorts(), system.getProtocol(), ignoreUrl);
        }
        if (specificationDiscoveryResult == null) {
            log.debug("Not found specifications for system: {}", (Object)system.getName());
            this.addProgress();
            return null;
        }
        Set oldSystemModelsIds = this.systemModelService.getSystemModelsBySystemId(system.getId()).stream().map(AbstractEntity::getId).collect(Collectors.toSet());
        ArrayList<SpecificationGroup> createdGroups = new ArrayList<SpecificationGroup>();
        ArrayList<SystemModel> createdSpecifications = new ArrayList<SystemModel>();
        for (SpecificationDiscoveryDTO specificationDTO : specificationDiscoveryResult.getSpecificationDiscoveryDTOS()) {
            SpecificationGroup specificationGroup = this.specificationGroupService.getById(this.specificationGroupService.buildSpecificationGroupId(system, specificationDTO.getName()));
            if (specificationGroup == null) {
                specificationGroup = this.specificationGroupService.getSpecificationGroupByNameAndSystem(specificationDTO.getName(), system);
            }
            if (specificationGroup == null) {
                specificationGroup = this.specificationGroupService.createAndSaveUniqueSpecificationGroup(system, specificationDTO.getName(), specificationDTO.getType(), specificationDTO.getUrl(), Boolean.valueOf(true));
                createdGroups.add(specificationGroup);
            } else if (Objects.isNull(specificationGroup.getUrl()) || !specificationGroup.getUrl().equals(specificationDTO.getUrl())) {
                specificationGroup.setUrl(specificationDTO.getUrl());
                specificationGroup.setSynchronization(true);
                this.specificationGroupService.update(specificationGroup);
            }
            if (this.systemModelService.getSystemModelByVersionAndSpecificationGroupId(specificationGroup.getId(), specificationDTO.getVersion()) != null) continue;
            try {
                SystemModel model = this.createSpecification(specificationGroup, specificationDTO, oldSystemModelsIds, msg -> this.addErrorMessage(errorMessages, system.getInternalServiceName(), specificationDTO.getName(), msg));
                String groupId = specificationGroup.getId();
                if (!createdGroups.stream().noneMatch(group -> group.getId().equals(groupId))) continue;
                createdSpecifications.add(model);
            }
            catch (SpecificationDiscoveryException e) {
                this.addErrorMessage(errorMessages, system.getInternalServiceName(), specificationDTO.getName(), e.getMessage());
            }
        }
        this.addProgress();
        return new SpecificationChanges(createdGroups, createdSpecifications);
    }

    private KubeService findCorrespondingService(IntegrationSystem system, List<KubeService> services) {
        return services.stream().filter(kubeService -> kubeService.getName().equals(system.getInternalServiceName())).findAny().orElse(null);
    }

    private DiscoveryResultDTO toDiscoveryResultDTO(List<IntegrationSystem> discoveredSystems, List<SpecificationChanges> specificationChanges, List<SpecificationDiscoveryErrorMsg> errorMessages) {
        log.debug("Discovered systems size: {}. Specification changes size: {}", discoveredSystems, specificationChanges);
        DiscoveryResultDTO discoveryResultDTO = new DiscoveryResultDTO();
        List discoveredGroups = specificationChanges.stream().map(SpecificationChanges::getCreatedGroups).flatMap(Collection::stream).collect(Collectors.toList());
        List discoveredSpecifications = specificationChanges.stream().map(SpecificationChanges::getCreatedSpecifications).flatMap(Collection::stream).collect(Collectors.toList());
        discoveryResultDTO.setDiscoveredSystemIds(discoveredSystems.stream().map(AbstractEntity::getId).collect(Collectors.toList()));
        discoveryResultDTO.setDiscoveredGroupIds(discoveredGroups.stream().map(AbstractEntity::getId).collect(Collectors.toList()));
        discoveryResultDTO.setDiscoveredSpecificationIds(discoveredSpecifications.stream().map(AbstractEntity::getId).collect(Collectors.toList()));
        discoveryResultDTO.setUpdatedSystemsIds(discoveredSpecifications.stream().map(SystemModel::getSpecificationGroup).map(SpecificationGroup::getSystem).map(AbstractEntity::getId).collect(Collectors.toList()));
        discoveryResultDTO.setErrorMessages(errorMessages.stream().map(errMsg -> new DiscoveryErrorDTO(errMsg.getServiceName(), errMsg.getErrorMessage())).collect(Collectors.toList()));
        return discoveryResultDTO;
    }

    private SystemModel createSpecification(SpecificationGroup specificationGroup, SpecificationDiscoveryDTO specificationDTO, Set<String> oldSystemModelsIds, Consumer<String> messageHandler) {
        try {
            if (specificationDTO == null || StringUtils.isBlank((CharSequence)specificationDTO.getContent())) {
                throw new SpecificationDiscoveryException("Specification file not found");
            }
            SystemModel model = (SystemModel)this.specificationImportService.importSimpleSpecification(this.getSourceFileName(specificationGroup, specificationDTO), specificationGroup.getId(), specificationDTO.getType(), specificationDTO.getContent(), oldSystemModelsIds, messageHandler).join();
            model.setSource(SystemModelSource.DISCOVERED);
            this.systemModelService.update(model);
            return model;
        }
        catch (SpecificationDiscoveryException e) {
            log.error("Synced specification creation failed", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error("Synced specification creation failed", (Throwable)e);
            throw new SpecificationDiscoveryException("Synced specification creation failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private String getSourceFileName(SpecificationGroup specificationGroup, SpecificationDiscoveryDTO specificationDTO) {
        return StringUtils.isBlank((CharSequence)specificationDTO.getSourceFileName()) ? this.buildSpecificationFileName(specificationGroup, specificationDTO) : specificationDTO.getSourceFileName();
    }

    private String buildSpecificationFileName(SpecificationGroup specificationGroup, SpecificationDiscoveryDTO specificationDiscoveryDTO) {
        String specificationTypeName;
        StringBuilder sb = new StringBuilder();
        IntegrationSystem system = specificationGroup.getSystem();
        sb.append(system.getInternalServiceName()).append('-').append(specificationGroup.getName());
        if (!StringUtils.isBlank((CharSequence)specificationDiscoveryDTO.getVersion())) {
            sb.append('-').append(specificationDiscoveryDTO.getVersion());
        }
        if (!StringUtils.isBlank((CharSequence)(specificationTypeName = this.getSpecificationTypeName(system.getProtocol(), specificationDiscoveryDTO.getContent(), specificationDiscoveryDTO.getUrl())))) {
            sb.append('-').append(specificationTypeName);
        }
        String extension = ExportImportUtils.getExtensionByProtocolAndContentType((OperationProtocol)system.getProtocol(), (String)specificationDiscoveryDTO.getContentType());
        sb.append('.').append(extension);
        return sb.toString();
    }

    public String getSpecificationTypeName(OperationProtocol protocol, String specificationText, String url) {
        return switch (1.$SwitchMap$org$qubership$integration$platform$catalog$model$system$OperationProtocol[protocol.ordinal()]) {
            case 1 -> this.getSpecificationTypeNameFromText(specificationText, url);
            default -> protocol.getType();
        };
    }

    private String getSpecificationTypeNameFromText(String specificationText, String url) {
        try {
            JsonNode node;
            JsonNode jsonNode = node = DeserializationUtils.isJson((String)specificationText) ? this.objectMapper.readTree(specificationText) : this.yamlMapper.readTree(specificationText);
            if (!node.isObject()) {
                log.error("Specification from URL {} is not an object", (Object)url);
                return null;
            }
            ObjectNode specObj = (ObjectNode)node;
            return specObj.has("swagger") ? "swagger" : (specObj.has("openapi") ? "openapi" : null);
        }
        catch (JsonProcessingException ignored) {
            log.error("Error while processing specification from URL {}", (Object)url);
            return null;
        }
    }

    private String getSystemIdPostfix(String systemPostfix) {
        if (systemPostfix.isBlank()) {
            return systemPostfix;
        }
        return "-" + systemPostfix;
    }

    private SpecificationDiscoveryResult runSpecificationDiscovery(String serviceName, List<Integer> servicePorts, OperationProtocol protocol) {
        return this.runSpecificationDiscovery(serviceName, servicePorts, protocol, Collections.emptyList());
    }

    private SpecificationDiscoveryResult runSpecificationDiscovery(String serviceName, List<Integer> servicePorts, OperationProtocol protocol, List<String> ignoreUrls) {
        int port;
        List specifications = null;
        if ((servicePorts = new ArrayList<Integer>(servicePorts)).remove(PRIORITY_SERVICE_PORT)) {
            servicePorts.add(0, PRIORITY_SERVICE_PORT);
        }
        String serviceAddress = null;
        Iterator<Integer> iterator = servicePorts.iterator();
        while (iterator.hasNext() && CollectionUtils.isEmpty((Collection)(specifications = this.getServiceSpecificationsDTO(serviceAddress = this.constructEnvAddress(serviceName, port = iterator.next().intValue()), protocol, ignoreUrls)))) {
        }
        if (CollectionUtils.isEmpty(specifications)) {
            log.debug("Didn't find specifications for service {}", (Object)serviceName);
            return null;
        }
        return new SpecificationDiscoveryResult(serviceAddress, specifications);
    }

    private List<IntegrationSystem> createDiscoveredService(KubeService service, List<SpecificationDiscoveryErrorMsg> errorMessages) {
        ArrayList<IntegrationSystem> integrationSystems = new ArrayList<IntegrationSystem>(PROTOCOL_POSTFIX_MAP.keySet().size());
        for (Map.Entry entry : PROTOCOL_POSTFIX_MAP.entrySet()) {
            SpecificationDiscoveryResult discoveryResult;
            OperationProtocol protocolType = (OperationProtocol)entry.getKey();
            String systemPostfix = (String)entry.getValue();
            if (this.systemService.getByIdOrNull(this.constructSystemId(service, systemPostfix)) != null || (discoveryResult = this.runSpecificationDiscovery(service.getName(), service.getPorts(), protocolType)) == null) continue;
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            IntegrationSystem system = ((IntegrationSystem.IntegrationSystemBuilder)((IntegrationSystem.IntegrationSystemBuilder)((IntegrationSystem.IntegrationSystemBuilder)((IntegrationSystem.IntegrationSystemBuilder)((IntegrationSystem.IntegrationSystemBuilder)IntegrationSystem.builder().id(this.constructSystemId(service, systemPostfix))).name(StringUtils.trim((String)(service.getName() + " " + systemPostfix)))).internalServiceName(service.getName()).integrationSystemType(IntegrationSystemType.INTERNAL).protocol(protocolType).description("")).createdWhen(currentTime)).modifiedWhen(currentTime)).build();
            system = this.systemService.create(system);
            Environment environment = ((Environment.EnvironmentBuilder)Environment.builder().name(service.getName())).address(discoveryResult.getServiceAddress()).sourceType(OperationProtocol.isAsyncProtocol((OperationProtocol)protocolType) ? EnvironmentSourceType.MAAS_BY_CLASSIFIER : EnvironmentSourceType.MANUAL).build();
            environment = this.environmentService.create(environment, system);
            for (SpecificationDiscoveryDTO specificationDTO : discoveryResult.getSpecificationDiscoveryDTOS()) {
                SpecificationGroup specificationGroup = this.specificationGroupService.createAndSaveUniqueSpecificationGroup(system, specificationDTO.getName(), specificationDTO.getType(), specificationDTO.getUrl(), Boolean.valueOf(true));
                try {
                    this.createSpecification(specificationGroup, specificationDTO, Collections.emptySet(), msg -> this.addErrorMessage(errorMessages, service.getName(), specificationDTO.getName(), msg));
                }
                catch (SpecificationDiscoveryException e) {
                    this.addErrorMessage(errorMessages, service.getName(), specificationDTO.getName(), e.getMessage());
                }
            }
            integrationSystems.add(system);
        }
        this.addProgress();
        return integrationSystems;
    }

    @NotNull
    private String constructSystemId(KubeService service, String systemPostfix) {
        return service.getName() + this.getSystemIdPostfix(systemPostfix);
    }

    private void addErrorMessage(List<SpecificationDiscoveryErrorMsg> errorMessages, String serviceName, String specificationName, String message) {
        if (!StringUtils.isBlank((CharSequence)specificationName)) {
            serviceName = (String)serviceName + " " + specificationName;
        }
        errorMessages.add(new SpecificationDiscoveryErrorMsg((String)serviceName, message));
    }

    private String constructEnvAddress(String host, int port) {
        return host + ":" + port;
    }

    private String constructSpecAddress(String environmentAddress, String url) {
        String protocol = "http://";
        return "http://" + environmentAddress + url;
    }

    private List<SpecificationDiscoveryDTO> getServiceSpecificationsDTO(String environmentAddress, OperationProtocol protocol, List<String> ignoreUrls) {
        HashMap specificationUrls = new HashMap();
        if (protocol == OperationProtocol.HTTP) {
            specificationUrls = this.getSwaggerUrls(environmentAddress);
        } else if (protocol == OperationProtocol.KAFKA) {
            specificationUrls = this.getAsyncUrls(environmentAddress);
        }
        if (protocol != null) {
            return this.getServiceSpecificationsDTO((Map)specificationUrls, ignoreUrls, environmentAddress, protocol.getType());
        }
        return Collections.emptyList();
    }

    private List<SpecificationDiscoveryDTO> getServiceSpecificationsDTO(Map<String, String> specificationUrls, List<String> ignoreUrls, String environmentAddress, String specificationType) {
        ArrayList<SpecificationDiscoveryDTO> result = new ArrayList<SpecificationDiscoveryDTO>();
        for (Map.Entry<String, String> entry : specificationUrls.entrySet()) {
            String url = entry.getKey();
            if (ignoreUrls.contains(url)) continue;
            String name = entry.getValue();
            String address = this.constructSpecAddress(environmentAddress, url);
            DiscoveredSpecificationSource source = this.getSpecificationSource(address);
            if (Objects.isNull(source) || StringUtils.isBlank((CharSequence)source.content())) {
                log.debug("Specification source is blank for address: {}", (Object)address);
                continue;
            }
            String version = this.getSpecificationRawVersion(source.content(), address);
            if (StringUtils.isBlank((CharSequence)version)) continue;
            result.add(new SpecificationDiscoveryDTO(specificationType, name, url, source.contentType(), source.content(), version, ""));
        }
        return result;
    }

    private HashMap<String, String> getAsyncUrls(String environmentAddress) {
        String[] asyncConfigUrl = new String[]{"/asyncApi/specification"};
        HashMap<String, String> asyncUrls = new HashMap<String, String>();
        for (String url : asyncConfigUrl) {
            String address = this.constructSpecAddress(environmentAddress, url);
            String httpResponse = this.getStringFromRemote(address);
            if (StringUtils.isBlank((CharSequence)httpResponse)) continue;
            try {
                JsonNode node = this.objectMapper.readTree(httpResponse);
                for (JsonNode asyncObjNode : node) {
                    String specName;
                    String specId = asyncObjNode.get(SPEC_FIELD_ID).asText();
                    String specVersion = asyncObjNode.get(SPEC_FIELD_VERSION).asText();
                    String string = specName = asyncObjNode.get(SPEC_FIELD_NAME) == null ? null : asyncObjNode.get(SPEC_FIELD_NAME).asText();
                    if (StringUtils.isBlank((CharSequence)specName)) {
                        specName = specId;
                    }
                    asyncUrls.put(url + "/" + specId + "/version/" + specVersion, specName);
                }
            }
            catch (IOException | NullPointerException ignored) {
                log.error("Error while reading response from address {}", (Object)address);
            }
        }
        return asyncUrls;
    }

    private HashMap<String, String> getSwaggerUrls(String environmentAddress) {
        String[] swaggerConfigUrl = new String[]{"/v3/api-docs/swagger-config", "/swagger-resources"};
        String[] swaggerDefaultUrl = new String[]{"/q/openapi", "/v3/api-docs", "/v2/api-docs", "/v1/api-docs", "/api-docs", "/swagger-ui/swagger.json"};
        String defaultSpecName = "default";
        HashMap<String, String> swaggerUrls = new HashMap<String, String>();
        for (String url : swaggerConfigUrl) {
            String address = this.constructSpecAddress(environmentAddress, url);
            String httpResponse = this.getStringFromRemote(address);
            if (StringUtils.isBlank((CharSequence)httpResponse)) continue;
            try {
                JsonNode node = this.objectMapper.readTree(httpResponse);
                if (node.has(SPEC_FIELD_URL)) {
                    swaggerUrls.put(node.get(SPEC_FIELD_URL).asText(), "default");
                    continue;
                }
                if (!node.has(SPEC_FIELD_URL_LIST) && !node.isArray()) continue;
                JsonNode rootArrUrlNode = node.has(SPEC_FIELD_URL_LIST) ? node.get(SPEC_FIELD_URL_LIST) : node;
                for (JsonNode urlNode : rootArrUrlNode) {
                    String specName;
                    String string = specName = urlNode.has(SPEC_FIELD_NAME) ? urlNode.get(SPEC_FIELD_NAME).asText() : null;
                    if (StringUtils.isBlank((CharSequence)specName)) {
                        specName = urlNode.get(SPEC_FIELD_URL).asText();
                    }
                    swaggerUrls.put(urlNode.get(SPEC_FIELD_URL).asText(), specName);
                }
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        }
        if (swaggerUrls.isEmpty()) {
            for (String url : swaggerDefaultUrl) {
                swaggerUrls.put(url, "default");
            }
        }
        return swaggerUrls;
    }

    private String getStringFromRemote(String address) {
        try {
            return (String)this.restTemplate.getForObject(address, String.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("Error while receiving spec from address: {}, exception: {}", (Object)address, (Object)e.getMessage());
            return null;
        }
    }

    private DiscoveredSpecificationSource getSpecificationSource(String address) {
        try {
            ResponseEntity response = this.restTemplate.getForEntity(address, String.class, new Object[0]);
            String type = response.getHeaders().getFirst("Content-Type");
            String text = (String)response.getBody();
            return new DiscoveredSpecificationSource(type, text);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getSpecificationRawVersion(String specificationContent, String address) {
        String version;
        try {
            try {
                version = this.objectMapper.readTree(specificationContent).get(SPEC_FIELD_INFO).get(SPEC_FIELD_VERSION).asText("");
            }
            catch (IOException | NullPointerException e) {
                version = this.yamlMapper.readTree(specificationContent).get(SPEC_FIELD_INFO).get(SPEC_FIELD_VERSION).asText("");
            }
        }
        catch (IOException | NullPointerException e) {
            log.error("Error while parsing version from address: {}", (Object)address);
            return null;
        }
        return version;
    }

    public List<DiscoveredServiceDTO> getServices() {
        return this.discoveryServiceMapper.toDiscoveredServiceDTOs(this.systemService.getAllDiscoveredServices());
    }

    private void setDiscoveryStatusResult(DiscoveryResultDTO result, String errorMessage) {
        this.setDiscoveryStatus(DISCOVERY_COMPLETE);
        ConfigParameter cp = new ConfigParameter(DISCOVERY_NAMESPACE, DISCOVERY_RESULT_NAME);
        DiscoveryStatusDTO dto = new DiscoveryStatusDTO(result, errorMessage);
        try {
            cp.setString(this.objectMapper.writeValueAsString((Object)dto));
            this.configParameterService.update(cp);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to set discovery status: " + e.getMessage());
        }
    }

    private void setDiscoveryStatus(String discoveryProgress) {
        ConfigParameter cp = new ConfigParameter(DISCOVERY_NAMESPACE, DISCOVERY_PROGRESS_NAME);
        cp.setString(discoveryProgress);
        this.configParameterService.update(cp);
        this.configParameterService.flush();
    }

    public String getDiscoveryProgress() {
        String progress;
        int entityExpiredTimeoutMinutes = 15;
        ConfigParameter cp = this.configParameterService.findByName(DISCOVERY_NAMESPACE, DISCOVERY_PROGRESS_NAME);
        String string = progress = cp == null ? null : cp.getString().split("\\.")[0];
        if (progress == null || cp.getModifiedWhen().before(Timestamp.valueOf(LocalDateTime.now().minusMinutes(15L)))) {
            return DISCOVERY_COMPLETE;
        }
        return progress;
    }

    public boolean isDiscoveryComplete() {
        return this.getDiscoveryProgress().equals(DISCOVERY_COMPLETE);
    }

    public DiscoveryResultDTO getDiscoveryResult() {
        ConfigParameter cp = this.configParameterService.findByName(DISCOVERY_NAMESPACE, DISCOVERY_RESULT_NAME);
        String rawStatusData = cp == null ? null : cp.getString();
        DiscoveryStatusDTO status = new DiscoveryStatusDTO();
        try {
            status = (DiscoveryStatusDTO)this.objectMapper.readValue(rawStatusData, DiscoveryStatusDTO.class);
        }
        catch (JsonProcessingException | RuntimeException throwable) {
            // empty catch block
        }
        if (status == null) {
            throw new RuntimeException("Unknown error, no status available");
        }
        String errorMessage = status.getErrorMessage();
        if (!StringUtils.isBlank((CharSequence)errorMessage)) {
            throw new RuntimeException("Error in Autodiscovery service: " + errorMessage);
        }
        return status.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProgress() {
        Object object = this.lock;
        synchronized (object) {
            ConfigParameter cp = this.configParameterService.findByName(DISCOVERY_NAMESPACE, DISCOVERY_PROGRESS_NAME);
            double currentProgress = cp == null ? 0.0 : Double.parseDouble(cp.getString());
            log.info("Current progress: {}", (Object)currentProgress);
            this.setDiscoveryStatus(String.valueOf(currentProgress + this.percent));
        }
    }
}

