/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.designtime.catalog.service.ElementService;
import org.qubership.integration.platform.designtime.catalog.service.SpecificationGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElementModificationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElementModificationService.class);
    private final SpecificationGroupService specificationGroupService;
    private final ElementService elementService;

    @Autowired
    public ElementModificationService(SpecificationGroupService specificationGroupService, ElementService elementService) {
        this.specificationGroupService = specificationGroupService;
        this.elementService = elementService;
    }

    public void makeHttpTriggersTypeImplemented(List<String> httpTriggerIds, String specificationGroupId) {
        SpecificationGroup specificationGroup = this.specificationGroupService.getById(specificationGroupId);
        List<ChainElement> chainElements = httpTriggerIds.stream().map(arg_0 -> ((ElementService)this.elementService).findById(arg_0)).toList();
        Operation operation = null;
        if (specificationGroup != null) {
            SystemModel latestSystemModel = specificationGroup.getSystemModels().stream().sorted(Comparator.comparing(AbstractEntity::getCreatedWhen).reversed()).toList().get(0);
            for (ChainElement element : chainElements) {
                Map elementProperties = element.getProperties();
                if (latestSystemModel != null) {
                    operation = latestSystemModel.getOperations().stream().findFirst().orElse(null);
                    elementProperties.put("integrationSpecificationId", latestSystemModel.getId());
                }
                if (operation != null) {
                    elementProperties.put("integrationOperationId", operation.getId());
                    elementProperties.put("integrationOperationPath", operation.getPath());
                    elementProperties.put("httpMethodRestrict", operation.getMethod());
                }
                elementProperties.put("systemType", "IMPLEMENTED");
                elementProperties.put("integrationSystemId", specificationGroup.getSystem().getId());
                elementProperties.put("integrationSpecificationGroupId", specificationGroup.getId());
                elementProperties.put("contextPath", null);
                element.setProperties(elementProperties);
                this.elementService.save(element);
            }
        }
    }
}

