/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.FoldableEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ChainRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.FolderRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.FolderMoveException;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.chain.ChainSearchRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.folder.FolderContentFilter;
import org.qubership.integration.platform.designtime.catalog.service.DeploymentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FolderService {
    private static final String FOLDER_WITH_ID_NOT_FOUND_MESSAGE = "Can't find folder with id: ";
    private final FolderRepository folderRepository;
    private final ChainRepository chainRepository;
    private final DeploymentService deploymentService;
    private final ActionsLogService actionLogger;
    private final AuditingHandler auditingHandler;

    @Autowired
    public FolderService(FolderRepository folderRepository, ChainRepository chainRepository, DeploymentService deploymentService, ActionsLogService actionLogger, AuditingHandler jpaAuditingHandler) {
        this.folderRepository = folderRepository;
        this.chainRepository = chainRepository;
        this.deploymentService = deploymentService;
        this.actionLogger = actionLogger;
        this.auditingHandler = jpaAuditingHandler;
    }

    public List<Folder> findAllInRoot() {
        return this.folderRepository.findAllByParentFolderIsNull();
    }

    public Folder findById(String id) {
        return (Folder)this.folderRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(FOLDER_WITH_ID_NOT_FOUND_MESSAGE + id));
    }

    public Folder findFirstByName(String name, Folder parent) {
        return this.folderRepository.findFirstByNameAndParentFolder(name, parent);
    }

    public Map<String, String> provideNavigationPath(String folderId) {
        Folder folder = this.findById(folderId);
        return folder.getAncestors();
    }

    public Folder findEntityByIdOrNull(String folderId) {
        return folderId != null ? (Folder)this.folderRepository.findById((Object)folderId).orElse(null) : null;
    }

    public Folder move(String folderId, String targetFolderId) throws FolderMoveException {
        Folder folder = this.findById(folderId);
        Folder targetFolder = this.findEntityByIdOrNull(targetFolderId);
        if (targetFolder != null && this.checkIfMovingToChild(folder, targetFolder)) {
            throw new FolderMoveException(folder.getName(), targetFolder.getName());
        }
        folder.setParentFolder(targetFolder);
        return folder;
    }

    private boolean checkIfMovingToChild(Folder folder, Folder targetFolder) {
        while (targetFolder.getParentFolder() != null) {
            Folder parentFolder = targetFolder.getParentFolder();
            if (parentFolder.getId().equals(folder.getId())) {
                return true;
            }
            targetFolder = parentFolder;
        }
        return false;
    }

    public Folder save(Folder folder, String parentFolderId) {
        this.auditingHandler.markModified((Object)folder);
        return this.upsertFolder(folder, parentFolderId);
    }

    public Folder save(Folder folder, Folder parentFolder) {
        if (parentFolder == null) {
            return this.save(folder, (String)null);
        }
        return this.save(folder, parentFolder.getId());
    }

    public Folder update(Folder entityFromDto, String folderId, String parentFolderId) {
        Folder folder = this.findById(folderId);
        folder.merge((AbstractEntity)entityFromDto);
        return this.upsertFolder(folder, parentFolderId);
    }

    public List<Folder> searchFolders(ChainSearchRequestDTO searchRequest) {
        return this.folderRepository.findByNameContaining(searchRequest.getSearchCondition());
    }

    public List<Folder> getFoldersHierarchically(List<? extends FoldableEntity> relatedChains) {
        List foldersIds = relatedChains.stream().map(FoldableEntity::getParentFolder).filter(Objects::nonNull).map(AbstractEntity::getId).collect(Collectors.toList());
        return this.folderRepository.getFoldersHierarchically(foldersIds);
    }

    private Folder upsertFolder(Folder folder, String parentFolderId) {
        Folder newFolder = (Folder)this.folderRepository.save((Object)folder);
        if (parentFolderId != null) {
            Folder parentFolder = this.findEntityByIdOrNull(parentFolderId);
            parentFolder.addChildFolder(newFolder);
            newFolder = (Folder)this.folderRepository.save((Object)newFolder);
        }
        return newFolder;
    }

    public void deleteById(String folderId) {
        Folder folder = this.findById(folderId);
        this.deleteRuntimeDeployments(folder);
        List nestedEntities = this.findAllNestedFoldableEntity(folderId);
        this.folderRepository.deleteById((Object)folderId);
        for (FoldableEntity entity : nestedEntities) {
            if (entity instanceof Folder) continue;
            this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.CHAIN).entityId(entity.getId()).entityName(entity.getName()).parentType(entity.getParentFolder() == null ? null : EntityType.FOLDER).parentId(entity.getParentFolder() == null ? null : entity.getParentFolder().getId()).parentName(entity.getParentFolder() == null ? null : entity.getParentFolder().getName()).operation(LogOperation.DELETE).build());
        }
    }

    private void deleteRuntimeDeployments(Folder folder) {
        for (Chain chain : folder.getChainList()) {
            this.deploymentService.deleteAllByChainId(chain.getId());
        }
        for (Folder subfolder : folder.getFolderList()) {
            this.deleteRuntimeDeployments(subfolder);
        }
    }

    private List<FoldableEntity> findAllNestedFoldableEntity(String folderId) {
        ArrayList<FoldableEntity> entities = new ArrayList<FoldableEntity>();
        this.folderRepository.findById((Object)folderId).ifPresent(value -> this.collectAllNestedFoldableEntityRecursive(entities, value));
        return entities;
    }

    private void collectAllNestedFoldableEntityRecursive(List<FoldableEntity> entities, Folder folder) {
        entities.add((FoldableEntity)folder);
        entities.addAll(folder.getChainList());
        for (Folder subfolder : folder.getFolderList()) {
            this.collectAllNestedFoldableEntityRecursive(entities, subfolder);
        }
    }

    public List<Chain> findNestedChains(String folderId, FolderContentFilter filter) {
        List nestedFolders = this.folderRepository.findNestedFolders(folderId);
        Specification specification = (root, query, criteriaBuilder) -> criteriaBuilder.or((Expression)root.get("parentFolder").in((Collection)nestedFolders), (Expression)criteriaBuilder.equal((Expression)root.get("parentFolder").get("id"), (Object)folderId));
        if (Objects.nonNull(filter)) {
            specification = specification.and(filter.getSpecification());
        }
        return this.chainRepository.findAll(specification);
    }

    public List<Folder> findNestedFolders(String folderId) {
        return this.folderRepository.findNestedFolders(folderId);
    }

    public List<Folder> findAllFoldersToRootParentFolder(String openedFolderId) {
        return this.folderRepository.findAllFoldersToRootParentFolder(openedFolderId);
    }
}

