/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.exception.SpecificationImportException;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroupLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SpecificationGroupLabelsRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SpecificationGroupRepository;
import org.qubership.integration.platform.catalog.service.AbstractSpecificationGroupService;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.exportimport.ProtocolExtractionService;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.SpecificationDeleteException;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.qubership.integration.platform.designtime.catalog.service.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.stereotype.Service;

@Service
public class SpecificationGroupService
extends AbstractSpecificationGroupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpecificationGroupService.class);
    private final SystemService systemService;
    private final ProtocolExtractionService protocolExtractionService;
    private final ChainService chainService;

    @Autowired
    public SpecificationGroupService(SpecificationGroupRepository specificationGroupRepository, ActionsLogService actionLogger, SystemService systemService, ProtocolExtractionService protocolExtractionService, @Lazy ChainService chainService, SpecificationGroupLabelsRepository specificationGroupLabelsRepository) {
        super(specificationGroupRepository, actionLogger, specificationGroupLabelsRepository);
        this.systemService = systemService;
        this.protocolExtractionService = protocolExtractionService;
        this.chainService = chainService;
    }

    public SpecificationGroup createAndSaveSpecificationGroup(IntegrationSystem system, String specificationId, String specificationName, String specificationType, String specificationUrl, Boolean synchronization) {
        if (system == null) {
            throw new SpecificationImportException("Can't find system with given id");
        }
        if (this.specificationGroupRepository.findByNameAndSystem(specificationName, system) != null) {
            throw new SpecificationImportException("Specification group name is not unique");
        }
        SpecificationGroup specificationGroup = new SpecificationGroup();
        specificationGroup.setName(specificationName);
        specificationGroup.setId(specificationId);
        specificationGroup.setUrl(specificationUrl);
        specificationGroup.setSynchronization(synchronization.booleanValue());
        specificationGroup = (SpecificationGroup)this.specificationGroupRepository.save((Object)specificationGroup);
        system.addSpecificationGroup(specificationGroup);
        system.setProtocol(this.protocolExtractionService.getProtocol(specificationType));
        this.systemService.update(system);
        this.logSpecGroupAction(specificationGroup, system, LogOperation.CREATE);
        return specificationGroup;
    }

    public SpecificationGroup createAndSaveSpecificationGroup(String systemId, String name, String description, String url, boolean synchronization) {
        return this.createAndSaveSpecificationGroup(this.systemService.getByIdOrNull(systemId), name, description, url, synchronization);
    }

    public SpecificationGroup createAndSaveSpecificationGroup(IntegrationSystem system, String groupName, String description, String url, boolean synchronization) {
        if (system == null) {
            throw new SpecificationImportException("Can't find system with given id");
        }
        if (this.specificationGroupRepository.findByNameAndSystem(groupName, system) != null) {
            throw new SpecificationImportException("Specification group name is not unique");
        }
        SpecificationGroup specificationGroup = new SpecificationGroup();
        specificationGroup.setId(this.buildSpecificationGroupId(system, groupName));
        specificationGroup.setName(groupName);
        specificationGroup.setDescription(description);
        specificationGroup.setUrl(url);
        specificationGroup.setSynchronization(synchronization);
        specificationGroup = (SpecificationGroup)this.specificationGroupRepository.save((Object)specificationGroup);
        system.addSpecificationGroup(specificationGroup);
        this.systemService.update(system);
        this.logSpecGroupAction(specificationGroup, system, LogOperation.CREATE);
        return specificationGroup;
    }

    public SpecificationGroup createAndSaveUniqueSpecificationGroup(IntegrationSystem system, String specificationName, String specificationType, String specificationUrl, Boolean synchronization) {
        String name = this.getUniqueName(system, specificationName);
        String id = this.buildSpecificationGroupId(system, specificationName);
        if (this.specGroupWithIdExists((Collection)system.getSpecificationGroups(), id)) {
            id = this.buildSpecificationGroupId(system, name);
        }
        return this.createAndSaveSpecificationGroup(system, id, name, specificationType, specificationUrl, synchronization);
    }

    public SpecificationGroup getSpecificationGroupBySystemIdAndUrl(String systemId, String url) {
        try {
            return this.specificationGroupRepository.findBySystemIdAndUrl(systemId, url);
        }
        catch (IncorrectResultSizeDataAccessException exception) {
            throw new DuplicateKeyException("Not unique specification group url found: " + url, (Throwable)exception);
        }
    }

    public SpecificationGroup getSpecificationGroupByNameAndSystem(String specificationGroupName, IntegrationSystem system) {
        try {
            return this.specificationGroupRepository.findByNameAndSystem(specificationGroupName, system);
        }
        catch (IncorrectResultSizeDataAccessException exception) {
            log.error("Not unique specification group name {}, for system {}", (Object)specificationGroupName, (Object)system.getName());
            throw new DuplicateKeyException("Not unique specification group name found: " + specificationGroupName, (Throwable)exception);
        }
    }

    public List<SpecificationGroup> getSpecificationGroups(String systemId) {
        List specificationGroups = this.specificationGroupRepository.findAllBySystemId(systemId);
        List<SpecificationGroup> specificationGroupsSorted = specificationGroups.stream().peek(arg_0 -> this.enrichSpecificationGroupWithChains(arg_0)).sorted((sg1, sg2) -> sg2.getName().compareTo(sg1.getName())).collect(Collectors.toList());
        specificationGroupsSorted.forEach(specificationGroup -> specificationGroup.getSystemModels().sort((sm1, sm2) -> sm1.getVersion().compareTo(sm2.getVersion())));
        return specificationGroupsSorted;
    }

    public void delete(String specificationGroupId) {
        if (this.chainService.isSpecificationGroupUsedByChain(specificationGroupId)) {
            throw new SpecificationDeleteException("Specification group used by one or more chains");
        }
        SpecificationGroup specificationGroup = (SpecificationGroup)this.specificationGroupRepository.getReferenceById((Object)specificationGroupId);
        IntegrationSystem system = specificationGroup.getSystem();
        this.specificationGroupRepository.delete((Object)specificationGroup);
        system.removeSpecificationGroup(specificationGroup);
        this.logSpecGroupAction(specificationGroup, system, LogOperation.DELETE);
    }

    public SpecificationGroup update(SpecificationGroup specificationGroup) {
        return this.update(specificationGroup, null);
    }

    public SpecificationGroup update(SpecificationGroup specificationGroup, List<SpecificationGroupLabel> newLabels) {
        this.replaceLabels(specificationGroup, newLabels);
        specificationGroup = (SpecificationGroup)this.specificationGroupRepository.save((Object)specificationGroup);
        this.logSpecGroupAction(specificationGroup, specificationGroup.getSystem(), LogOperation.UPDATE);
        return specificationGroup;
    }

    public void replaceLabels(SpecificationGroup specificationGroup, List<SpecificationGroupLabel> newLabels) {
        if (newLabels == null) {
            return;
        }
        List finalNewLabels = newLabels;
        SpecificationGroup finalSpecificationGroup = specificationGroup;
        finalNewLabels.forEach(label -> label.setSpecificationGroup(finalSpecificationGroup));
        specificationGroup.getLabels().removeIf(l -> !l.isTechnical() && !finalNewLabels.stream().map(AbstractLabel::getName).collect(Collectors.toSet()).contains(l.getName()));
        finalNewLabels.removeIf(l -> l.isTechnical() || finalSpecificationGroup.getLabels().stream().filter(lab -> !lab.isTechnical()).map(AbstractLabel::getName).collect(Collectors.toSet()).contains(l.getName()));
        newLabels = this.specificationGroupLabelsRepository.saveAll(finalNewLabels);
        specificationGroup.addLabels((Collection)newLabels);
    }

    public String getUniqueName(IntegrationSystem system, String desiredName) {
        Object newName = desiredName;
        int iterator = 0;
        while (this.specGroupWithNameExists((Collection)system.getSpecificationGroups(), (String)newName)) {
            newName = desiredName + " (" + ++iterator + ")";
        }
        return newName;
    }

    private boolean specGroupWithNameExists(Collection<SpecificationGroup> specGroups, String name) {
        if (specGroups == null) {
            return false;
        }
        return specGroups.stream().anyMatch(specGroup -> name.equals(specGroup.getName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean specGroupWithIdExists(Collection<SpecificationGroup> specificationGroups, String id) {
        if (!Objects.nonNull(specificationGroups)) return false;
        if (!specificationGroups.stream().map(AbstractEntity::getId).anyMatch(id::equals)) return false;
        return true;
    }

    private void enrichSpecificationGroupWithChains(SpecificationGroup specificationGroup) {
        List chains = this.chainService.findBySystemAndGroupId(specificationGroup.getSystem().getId(), specificationGroup.getId());
        specificationGroup.setChains(chains);
        for (SystemModel model : specificationGroup.getSystemModels()) {
            List modelChains = chains.stream().flatMap(modelChain -> modelChain.getElements().stream()).filter(chainElement -> StringUtils.equals((CharSequence)model.getId(), (CharSequence)chainElement.getPropertyAsString("integrationSpecificationId"))).map(ChainElement::getChain).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            model.setChains(modelChains);
        }
    }
}

