/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.model.library.ElementType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.designtime.catalog.configuration.aspect.ChainModification;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ElementDeletionException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ElementTransferException;
import org.qubership.integration.platform.designtime.catalog.model.ChainDiff;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.qubership.integration.platform.designtime.catalog.service.ElementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwimlaneService {
    public static final String SWIMLANE_TYPE_NAME = "swimlane";
    public static final String COLOR_PROPERTY_NAME = "color";
    public static final String DEFAULT_SWIMLANE_NAME = "Default swimlane";
    public static final String REUSE_SWIMLANE_NAME = "Reuse swimlane";
    public static final String REUSE_SWIMLANE_COLOR = "Green";
    private final LibraryElementsService libraryService;
    private final ElementService elementService;
    private final ChainService chainService;

    @Autowired
    public SwimlaneService(LibraryElementsService libraryService, @Lazy ElementService elementService, @Lazy ChainService chainService) {
        this.libraryService = libraryService;
        this.elementService = elementService;
        this.chainService = chainService;
    }

    @Transactional
    @ChainModification
    public ChainDiff create(String chainId) {
        ChainDiff chainDiff = new ChainDiff();
        ElementDescriptor elementDescriptor = this.libraryService.getElementDescriptor(SWIMLANE_TYPE_NAME);
        Chain chain = this.chainService.findById(chainId);
        if (chain.getDefaultSwimlane() != null) {
            SwimlaneChainElement swimlaneElement = this.createSwimlaneElement(elementDescriptor.getTitle(), elementDescriptor, chain);
            chainDiff.addCreatedElement(this.elementService.save((ChainElement)swimlaneElement));
        } else {
            SwimlaneChainElement defaultSwimlane = this.createSwimlaneElement(DEFAULT_SWIMLANE_NAME, elementDescriptor, chain);
            defaultSwimlane = (SwimlaneChainElement)this.elementService.save((ChainElement)defaultSwimlane);
            chain.setDefaultSwimlane(defaultSwimlane);
            chainDiff.addUpdatedElements(this.updateSwimlaneForElements(defaultSwimlane, chain.getRootElements(), descriptor -> descriptor == null || descriptor.getType() != ElementType.REUSE));
            chainDiff.addCreatedElement((ChainElement)defaultSwimlane);
            chainDiff.setCreatedDefaultSwimlaneId(defaultSwimlane.getId());
            boolean chainHasReuseElements = chain.getElements().stream().map(arg_0 -> ((LibraryElementsService)this.libraryService).getElementDescriptor(arg_0)).anyMatch(descriptor -> ElementType.REUSE == descriptor.getType());
            if (chainHasReuseElements) {
                SwimlaneChainElement reuseSwimlane = this.createSwimlaneElement(REUSE_SWIMLANE_NAME, elementDescriptor, chain);
                reuseSwimlane.getProperties().put(COLOR_PROPERTY_NAME, REUSE_SWIMLANE_COLOR);
                reuseSwimlane = (SwimlaneChainElement)this.elementService.save((ChainElement)reuseSwimlane);
                chain.setReuseSwimlane(reuseSwimlane);
                chainDiff.addUpdatedElements(this.updateSwimlaneForElements(reuseSwimlane, chain.getRootElements(), descriptor -> descriptor != null && descriptor.getType() == ElementType.REUSE));
                chainDiff.addCreatedElement((ChainElement)reuseSwimlane);
                chainDiff.setCreatedReuseSwimlaneId(reuseSwimlane.getId());
            }
            this.chainService.save(chain);
        }
        return chainDiff;
    }

    @Transactional
    @ChainModification
    public SwimlaneChainElement createReuseSwimlane(Chain chain) {
        ElementDescriptor elementDescriptor = this.libraryService.getElementDescriptor(SWIMLANE_TYPE_NAME);
        SwimlaneChainElement reuseSwimlane = this.createSwimlaneElement(REUSE_SWIMLANE_NAME, elementDescriptor, chain);
        reuseSwimlane.getProperties().put(COLOR_PROPERTY_NAME, REUSE_SWIMLANE_COLOR);
        reuseSwimlane = (SwimlaneChainElement)this.elementService.save((ChainElement)reuseSwimlane);
        chain.setReuseSwimlane(reuseSwimlane);
        this.chainService.save(chain);
        return reuseSwimlane;
    }

    @Transactional
    @ChainModification
    public ChainDiff transferElementsToSwimlane(String chainId, String swimlaneId, List<ChainElement> elements) {
        Chain chain = this.chainService.findById(chainId);
        ChainDiff chainDiff = new ChainDiff();
        for (ChainElement element : elements) {
            chainDiff.merge(this.transferElementToSwimlane(chain, swimlaneId, element));
        }
        return chainDiff;
    }

    @Transactional
    @ChainModification
    public ChainDiff transferElementToSwimlane(Chain chain, String swimlaneId, ChainElement element) {
        ChainDiff chainDiff = new ChainDiff();
        SwimlaneChainElement swimlane = chain.getElements().stream().filter(chainElement -> chainElement instanceof SwimlaneChainElement).filter(swimlaneElement -> StringUtils.equals((CharSequence)swimlaneElement.getId(), (CharSequence)swimlaneId)).findFirst().orElse(null);
        ElementDescriptor elementDescriptor = this.libraryService.getElementDescriptor(element);
        if (ElementType.REUSE != elementDescriptor.getType()) {
            if (swimlane == null) {
                this.updateElementsHierarchy(Collections.singletonList(element), chainElement -> chainElement.setSwimlane(chain.getDefaultSwimlane()));
            } else {
                boolean parentElementReuse = Optional.ofNullable(this.elementService.findRootParent(element)).map(arg_0 -> ((LibraryElementsService)this.libraryService).getElementDescriptor(arg_0)).map(descriptor -> ElementType.REUSE == descriptor.getType()).orElse(false);
                if (Objects.equals(swimlane, chain.getReuseSwimlane()) && !parentElementReuse) {
                    throw new ElementTransferException("Element " + element.getId() + " cannot be moved to Reuse group");
                }
                this.updateElementsHierarchy(Collections.singletonList(element), chainElement -> chainElement.setSwimlane(swimlane));
            }
        } else {
            SwimlaneChainElement reuseSwimlane = Optional.ofNullable(chain.getReuseSwimlane()).orElseGet(() -> {
                SwimlaneChainElement swimlaneElement = null;
                if (chain.getDefaultSwimlane() != null) {
                    swimlaneElement = this.createReuseSwimlane(chain);
                    chainDiff.setCreatedReuseSwimlaneId(swimlaneElement.getId());
                    chainDiff.addCreatedElement((ChainElement)swimlaneElement);
                }
                return swimlaneElement;
            });
            this.updateElementsHierarchy(Collections.singletonList(element), chainElement -> chainElement.setSwimlane(reuseSwimlane));
            element.setSwimlane(reuseSwimlane);
        }
        this.elementService.save(element);
        chainDiff.addUpdatedElement(element);
        return chainDiff;
    }

    @Transactional
    @ChainModification
    public ChainDiff delete(String swimlaneId) {
        ChainDiff chainDiff = new ChainDiff();
        Optional swimlaneOptional = this.elementService.findSwimlaneWithLockingById(swimlaneId);
        if (swimlaneOptional.isEmpty()) {
            return chainDiff;
        }
        SwimlaneChainElement swimlaneElement = (SwimlaneChainElement)swimlaneOptional.get();
        Chain chain = swimlaneElement.getChain();
        if (swimlaneElement.isDefaultSwimlane()) {
            this.deleteDefaultSwimlane(chainDiff, chain);
        } else if (swimlaneElement.isReuseSwimlane()) {
            if (CollectionUtils.isEmpty((Collection)swimlaneElement.getElements())) {
                chain.removeElement((ChainElement)swimlaneElement);
                chain.setReuseSwimlane(null);
                this.elementService.delete((ChainElement)swimlaneElement);
                chainDiff.addRemovedElement((ChainElement)swimlaneElement);
            } else {
                this.deleteDefaultSwimlane(chainDiff, chain);
            }
        } else {
            SwimlaneChainElement defaultSwimlane = chain.getDefaultSwimlane();
            if (defaultSwimlane != null) {
                chainDiff.addUpdatedElements(this.updateSwimlaneForElements(defaultSwimlane, swimlaneElement.getRootElements(), descriptor -> true));
            } else {
                chainDiff.addUpdatedElements(this.removeElementsFromSwimlane(swimlaneElement, swimlaneElement.getRootElements()));
            }
            chain.removeElement((ChainElement)swimlaneElement);
            this.elementService.delete((ChainElement)swimlaneElement);
            chainDiff.addRemovedElement((ChainElement)swimlaneElement);
        }
        this.chainService.save(chain);
        return chainDiff;
    }

    private SwimlaneChainElement createSwimlaneElement(String name, ElementDescriptor elementDescriptor, Chain chain) {
        SwimlaneChainElement swimlaneElement = new SwimlaneChainElement();
        swimlaneElement.setName(name);
        swimlaneElement.setType(elementDescriptor.getName());
        swimlaneElement.setChain(chain);
        swimlaneElement.setProperties(this.elementService.createPropertiesMap(elementDescriptor.getProperties(), swimlaneElement.getId(), chain.getId()));
        swimlaneElement.setCreatedWhen(null);
        return swimlaneElement;
    }

    private List<ChainElement> updateSwimlaneForElements(SwimlaneChainElement groupElement, List<ChainElement> chainElements, Predicate<ElementDescriptor> elementFilter) {
        List<ChainElement> updatedElements = chainElements.stream().filter(element -> !SWIMLANE_TYPE_NAME.equals(element.getType())).filter(element -> elementFilter.test(this.libraryService.getElementDescriptor(element))).toList();
        this.updateElementsHierarchy(updatedElements, arg_0 -> ((SwimlaneChainElement)groupElement).addElement(arg_0));
        return updatedElements;
    }

    private List<ChainElement> removeElementsFromSwimlane(SwimlaneChainElement groupElement, List<ChainElement> elements) {
        this.updateElementsHierarchy(elements, arg_0 -> ((SwimlaneChainElement)groupElement).removeElement(arg_0));
        return elements;
    }

    private void updateElementsHierarchy(List<ChainElement> elements, Consumer<ChainElement> action) {
        elements.stream().peek(action).forEach(element -> {
            if (element instanceof ContainerChainElement) {
                this.updateElementsHierarchy(((ContainerChainElement)element).getElements(), action);
            }
        });
    }

    private void deleteDefaultSwimlane(ChainDiff chainDiff, Chain chain) {
        long commonSwimlanesCount = chain.getElements().stream().filter(element -> element instanceof SwimlaneChainElement).filter(swimlane -> !Objects.equals(swimlane, chain.getDefaultSwimlane()) && !Objects.equals(swimlane, chain.getReuseSwimlane())).count();
        if (commonSwimlanesCount > 0L) {
            throw new ElementDeletionException("Default and Reuse swimlanes cannot be removed if the chain contains other swimlanes");
        }
        SwimlaneChainElement defaultSwimlane = chain.getDefaultSwimlane();
        chainDiff.addUpdatedElements(this.removeElementsFromSwimlane(defaultSwimlane, defaultSwimlane.getRootElements()));
        chain.removeElement((ChainElement)defaultSwimlane);
        chain.setDefaultSwimlane(null);
        this.elementService.delete((ChainElement)defaultSwimlane);
        chainDiff.addRemovedElement((ChainElement)defaultSwimlane);
        this.elementService.findReuseSwimlaneWithLockingByChainId(chain.getId()).ifPresent(reuseSwimlane -> {
            chainDiff.addUpdatedElements(this.removeElementsFromSwimlane(reuseSwimlane, reuseSwimlane.getRootElements()));
            chain.removeElement((ChainElement)reuseSwimlane);
            chain.setReuseSwimlane(null);
            this.elementService.delete((ChainElement)reuseSwimlane);
            chainDiff.addRemovedElement((ChainElement)reuseSwimlane);
        });
    }
}

